/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.bin.BinaryUtilities;
import uk.ac.ox.well.t2d.async.gzip.GzipMetadata;

public class GzipMetadataComposer
extends GzipMetadata {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final String GZIP_TEXT_PROPERTY = "Gzip.Metadata.Text";
    public static final String GZIP_NAME_PROPERTY = "Gzip.Metadata.Name";
    public static final String GZIP_COMMENT_PROPERTY = "Gzip.Metadata.Comment";
    public static final String GZIP_SUBFIELDS_PROPERTY = "Gzip.Metadata.Subfields";

    public void setup(Contract c) {
        this.unpackMetadata(c);
        this.resetFlags();
    }

    public byte[] toHeaderBytes() {
        this.resetFlags();
        byte[] ba = new byte[10];
        ba[0] = (Byte)MAGIC_NUMBER.get(0);
        ba[1] = (Byte)MAGIC_NUMBER.get(1);
        ba[2] = 8;
        ba[3] = this.getFlags();
        byte[] mtime = this.getTimeBytes();
        System.arraycopy(mtime, 0, ba, 4, mtime.length);
        if (this.hasSubfields()) {
            ba = GzipMetadataComposer.concat(ba, this.getFExtraBytes());
        }
        if (null != this.name) {
            ba = GzipMetadataComposer.concat(ba, this.toZeroTerminated(this.name));
        }
        if (null != this.comment) {
            ba = GzipMetadataComposer.concat(ba, this.toZeroTerminated(this.comment));
        }
        return ba;
    }

    public ByteBuffer toHeaderByteBuffer() {
        ByteBuffer bb = ByteBuffer.wrap(this.toHeaderBytes());
        return bb;
    }

    public byte[] toFooterBytes() {
        byte[] ba = new byte[8];
        byte[] crcba = BinaryUtilities.longToBytesLe32(this.getCrc32());
        System.arraycopy(crcba, 0, ba, 0, crcba.length);
        byte[] lenba = BinaryUtilities.longToBytesLe32(this.getLength());
        System.arraycopy(lenba, 0, ba, 4, lenba.length);
        return ba;
    }

    public ByteBuffer toFooterByteBuffer() {
        ByteBuffer bb = ByteBuffer.wrap(this.toFooterBytes());
        return bb;
    }

    public void unpackMetadata(Contract c) {
        this.name = (String)c.get(GZIP_NAME_PROPERTY);
        this.comment = (String)c.get(GZIP_NAME_PROPERTY);
        if (c.containsKey(GZIP_TEXT_PROPERTY)) {
            this.setTextFlag((Boolean)c.get(GZIP_TEXT_PROPERTY));
        }
        this.subfields = (List)c.get(GZIP_SUBFIELDS_PROPERTY);
    }

    public void resetFlags() {
        if (this.hasSubfields()) {
            this.flags[2] = true;
        }
        if (null != this.name) {
            this.flags[3] = true;
        }
        if (null != this.comment) {
            this.flags[4] = true;
        }
    }

    public byte[] getTimeBytes() {
        long l = System.currentTimeMillis();
        return BinaryUtilities.longToBytesLe32(l /= 1000L);
    }

    public byte[] getOsBytes() {
        byte[] bs = new byte[]{-1};
        return bs;
    }

    public byte[] toZeroTerminated(String str) {
        if (null == str || str.isEmpty()) {
            return new byte[0];
        }
        byte[] sb = str.getBytes(US_ASCII);
        byte[] rb = new byte[sb.length + 1];
        System.arraycopy(sb, 0, rb, 0, sb.length);
        rb[rb.length - 1] = 0;
        return rb;
    }

    public byte[] getFExtraBytes() {
        byte[] ba = new byte[]{};
        if (null == this.subfields || this.subfields.isEmpty()) {
            return ba;
        }
        for (GzipMetadata.Subfield sf : this.subfields) {
            ba = GzipMetadataComposer.concat(ba, sf.toByteArray());
        }
        if (ba.length > 65535) {
            throw new RuntimeException("Unable to handle FEXTRA field greater than 16 bits in length. Found: " + ba.length);
        }
        byte[] len = BinaryUtilities.longToBytesLe16(ba.length);
        return GzipMetadataComposer.concat(len, ba);
    }

    public static byte[] concat(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

