/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip;

import java.util.Formatter;
import java.util.Stack;
import uk.ac.ox.well.t2d.async.bin.BinaryUtilities;
import uk.ac.ox.well.t2d.async.bin.ByteArrayHandler;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.ZeroTerminatedHandler;
import uk.ac.ox.well.t2d.async.gzip.ByteArrayWindow;
import uk.ac.ox.well.t2d.async.gzip.GzipException;
import uk.ac.ox.well.t2d.async.gzip.GzipMetadata;

public class GzipMetadataHandler
extends GzipMetadata {
    protected Stack<ByteHandler> stack = new Stack();
    protected boolean isHeaderComplete;
    protected int headerLength;
    protected ByteArrayWindow footer = new ByteArrayWindow(8);

    public GzipMetadataHandler() {
        this.setup();
    }

    public boolean isHeaderComplete() {
        return this.isHeaderComplete;
    }

    public boolean isFooterComplete() {
        return this.footer.isFull();
    }

    protected final void setup() {
        this.isHeaderComplete = false;
        this.footer.clear();
        this.stack.clear();
        this.stack.push(new Crc16Handler());
        this.stack.push(new CommentHandler());
        this.stack.push(new NameHandler());
        this.stack.push(new ExtraFieldsHandler());
        this.stack.push(new OsHandler());
        this.stack.push(new ExtraFlagsHandler());
        this.stack.push(new TimeHandler());
        this.stack.push(new FlagHandler());
        this.stack.push(new CompressionMethodHandler());
        this.stack.push(new MagicNumberHandler());
    }

    @Override
    public void clear() {
        super.clear();
        this.setup();
    }

    public boolean nextHeader(byte b) throws Exception {
        ++this.headerLength;
        if (!this.stack.empty() && this.stack.peek().next(b)) {
            this.stack.pop();
        }
        while (!this.stack.empty() && !this.stack.peek().isActive()) {
            this.stack.pop();
        }
        if (this.stack.isEmpty()) {
            this.isHeaderComplete = true;
            return true;
        }
        return false;
    }

    public boolean nextFooter(byte b) {
        this.footer.nextByte(b);
        return this.footer.isFull();
    }

    protected void validateFooter(long actualCrc32, long actualLength) throws GzipException {
        ByteArrayWindow baw = this.footer;
        if (8 != baw.getCount()) {
            throw new GzipException("Expecting a footer of 8 bytes. Found: " + baw.getCount());
        }
        byte[] bs = baw.getArray();
        long ftrLength = BinaryUtilities.captureLong(bs, 0, 4);
        long ftrCrc32 = BinaryUtilities.captureLong(bs, 4, 4);
        long length32 = actualLength & 0xFFFFFFFFL;
        if (ftrLength != length32 || ftrCrc32 != actualCrc32) {
            Formatter f = new Formatter();
            f.format("Mismatch when reading Gzip footer. Found in file ISIZE=%,d[%,d] & CRC32=%,d, found in footer ISIZE=%,d & CRC32=%,d", length32, actualLength, actualCrc32, ftrLength, ftrCrc32);
            throw new GzipException(f.toString());
        }
        this.length = actualLength;
        this.crc32 = actualCrc32;
    }

    public class ExtraFieldsHandler
    extends ByteHandler {
        byte b1 = 0;
        byte b2 = 0;
        byte[] array = null;

        @Override
        public boolean isActive() {
            return GzipMetadataHandler.this.isExtraFieldsFlag();
        }

        @Override
        public boolean next(byte b) {
            if (this.index == 0) {
                this.b1 = b;
                ++this.index;
                return false;
            }
            if (this.index == 1) {
                this.b2 = b;
                ++this.index;
                int length = (0xFF & this.b2) << 8 | 0xFF & this.b1;
                if (0 == length) {
                    return true;
                }
                this.array = new byte[length];
                return false;
            }
            this.array[this.index - 2] = b;
            ++this.index;
            if (this.index - 2 >= this.array.length) {
                GzipMetadataHandler.this.setSubfields(this.array);
                return true;
            }
            return false;
        }
    }

    public class CommentHandler
    extends ZeroTerminatedHandler {
        @Override
        public boolean isFlagSet() {
            return GzipMetadataHandler.this.isCommentFlag();
        }

        @Override
        public void setField(String str) {
            GzipMetadataHandler.this.comment = str;
        }
    }

    public class NameHandler
    extends ZeroTerminatedHandler {
        @Override
        public boolean isFlagSet() {
            return GzipMetadataHandler.this.isNameFlag();
        }

        @Override
        public void setField(String str) {
            GzipMetadataHandler.this.name = str;
        }
    }

    public class FlagHandler
    extends ByteHandler {
        @Override
        public boolean next(byte b) {
            GzipMetadataHandler.this.setFlags(b);
            return true;
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    public class CompressionMethodHandler
    extends ByteHandler {
        @Override
        public boolean next(byte b) throws Exception {
            if (b != 8) {
                Formatter f = new Formatter();
                f.format("Incorrect Compression method. Expecting 8, found: %d", b);
                throw new GzipException(f.toString());
            }
            return true;
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    public class OsHandler
    extends ByteArrayHandler {
        public OsHandler() {
            super(1);
        }

        @Override
        public void setField(byte[] b) throws GzipException {
            GzipMetadataHandler.this.setOs(b[0]);
        }
    }

    public class ExtraFlagsHandler
    extends ByteArrayHandler {
        public ExtraFlagsHandler() {
            super(1);
        }

        @Override
        public void setField(byte[] b) throws GzipException {
            GzipMetadataHandler.this.setExtraFlags(b[0]);
        }
    }

    public class Crc16Handler
    extends ByteArrayHandler {
        public Crc16Handler() {
            super(2);
        }

        @Override
        public boolean isActive() {
            return GzipMetadataHandler.this.isCrc16Flag();
        }

        @Override
        public void setField(byte[] b) throws GzipException {
            GzipMetadataHandler.this.setCrc16(b);
        }
    }

    public class TimeHandler
    extends ByteArrayHandler {
        public TimeHandler() {
            super(4);
        }

        @Override
        public void setField(byte[] b) throws GzipException {
            GzipMetadataHandler.this.setTime(b);
        }
    }

    public class MagicNumberHandler
    extends ByteArrayHandler {
        public MagicNumberHandler() {
            super(2);
        }

        @Override
        public void setField(byte[] b) throws GzipException {
            if (!GzipMetadataHandler.this.isMagicNumber(b)) {
                Formatter f = new Formatter();
                f.format("Incorrect Gzip Magic Number, found: %x %x", b[0], b[1]);
                throw new GzipException(f.toString());
            }
        }
    }
}

