/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip;

import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.io.IOProperties;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;

public class GzipProperties {
    public static final String GZIP_MODE = "GZIP_MODE";
    public static final String GZIP_EXTENSION = "gz";
    public static final String GZIP_PATH_SUFFIX = ".gz";

    public static boolean isGzipPath(String path) {
        return GzipProperties.isSuffix(GZIP_EXTENSION, path);
    }

    public static String stripGzipSuffix(String extension, String path) {
        return GzipProperties.stripSuffix(GZIP_EXTENSION, path);
    }

    public static boolean gzipPathExists(Contract c, String path) {
        return IOProperties.pathExists(c, path + GZIP_PATH_SUFFIX);
    }

    public static GzipMode getGzipMode(Contract c) {
        Object o = c.get(GZIP_MODE);
        if (null != o && o instanceof GzipMode) {
            return (GzipMode)((Object)o);
        }
        String str = (String)c.get(GZIP_MODE);
        if (null == str || str.isEmpty()) {
            return GzipMode.IF_SUFFIX;
        }
        return GzipMode.valueOf(str);
    }

    public static boolean detectGzip(Contract c) {
        GzipMode mode = GzipProperties.getGzipMode(c);
        String path = (String)c.get("IOProperties.OUT_PATH");
        if (null == path) {
            throw new RequiredPropertyValueNotFound("IOProperties.OUT_PATH");
        }
        switch (mode) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        return GzipProperties.isGzipPath(path);
    }

    public static String stripSuffix(String extension, String path) {
        if (GzipProperties.isSuffix(extension, path)) {
            int sfxlen = ("." + extension).length();
            String newPath = path.substring(0, path.length() - sfxlen);
            return newPath;
        }
        return path;
    }

    public static boolean isSuffix(String extension, String path) {
        return path.endsWith("." + extension);
    }

    public static enum GzipMode {
        ALL,
        IF_SUFFIX,
        NONE;

    }
}

