/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip.index;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.ox.well.t2d.async.gzip.index.GzipIndexEntry;

public class GzipIndex {
    protected final GzipIndexEntry entry = new GzipIndexEntry();
    protected final LookupResult result = new LookupResult();
    protected ArrayList<GzipIndexEntry> indexList = new ArrayList();
    protected GzipIndexEntry[] indexArray = null;

    public void addEntry(GzipIndexEntry gie) {
        this.indexList.add(gie);
    }

    public void materialize(boolean resort) {
        this.indexArray = this.indexList.toArray(new GzipIndexEntry[this.indexList.size()]);
        if (resort) {
            Arrays.sort(this.indexArray);
        }
        this.indexList = null;
    }

    public int size() {
        if (null == this.indexArray) {
            return 0;
        }
        return this.indexArray.length;
    }

    public boolean isMaterialized() {
        return null != this.indexArray;
    }

    public LookupResult lookup(long key) {
        this.result.clear();
        this.entry.setKeyValue(key);
        int i = Arrays.binarySearch(this.indexArray, this.entry);
        this.result.rawSearchResult = i;
        if (-1 == i) {
            this.result.type = ResultType.BELOW;
            return this.result;
        }
        if (this.indexArray.length - 1 == i) {
            --i;
        } else {
            if (this.indexArray.length * -1 > i) {
                this.result.type = ResultType.ABOVE;
                return this.result;
            }
            if (0 > i) {
                i = (i + 2) * -1;
            }
        }
        this.result.type = ResultType.OKAY;
        GzipIndexEntry gie = this.indexArray[i];
        this.result.chunkNumber = i + 1;
        this.result.keyValue = gie.getKeyValue();
        this.result.fromByte = gie.getByteOffset();
        this.result.toByte = this.indexArray[i + 1].getByteOffset();
        return this.result;
    }

    public class LookupResult {
        private ResultType type;
        private long rawSearchResult;
        private long chunkNumber;
        private long keyValue;
        private long fromByte;
        private long toByte;

        public boolean isOkay() {
            return this.type != null && this.type == ResultType.OKAY;
        }

        public void clear() {
            this.type = null;
            this.rawSearchResult = 0L;
            this.chunkNumber = 0L;
            this.keyValue = 0L;
            this.fromByte = 0L;
            this.toByte = 0L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ResultType:").append((Object)this.getType());
            sb.append(", RawSearchResult:").append(this.getRawSearchResult());
            sb.append(", ChunkNumber:").append(this.chunkNumber);
            sb.append(", KeyValue:").append(this.keyValue);
            sb.append(", FromByte:").append(this.fromByte);
            sb.append(", ToByte:").append(this.toByte);
            return sb.toString();
        }

        public long getChunkNumber() {
            return this.chunkNumber;
        }

        public long getKeyValue() {
            return this.keyValue;
        }

        public long getFromByte() {
            return this.fromByte;
        }

        public long getToByte() {
            return this.toByte;
        }

        public ResultType getType() {
            return this.type;
        }

        public long getRawSearchResult() {
            return this.rawSearchResult;
        }
    }

    public static enum ResultType {
        BELOW,
        ABOVE,
        OKAY;

    }
}

