/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip.index;

import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.gzip.index.GzipIndex;
import uk.ac.ox.well.t2d.async.gzip.index.GzipIndexEntry;
import uk.ac.ox.well.t2d.async.metadata.MdataLdrBlock;
import uk.ac.ox.well.t2d.async.metadata.PropertyInjector;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.ped.WhiteSpaceParsingLogic;
import uk.ac.ox.well.t2d.async.processors.PayloadManager;

public class GzipIndexLdrBlck
extends SubSection {
    public static final String GZIP_INDEX_KEY = "GzipIndexLdrBlck.Index";
    MdataLdrBlock ldr = new MdataLdrBlock();

    public GzipIndexLdrBlck() {
        this.ldr.setParser(new Parser());
        this.ldr.setInputPropertyKey("IOProperties.IN_PATH");
        this.ldr.setOutputPropertyKey(GZIP_INDEX_KEY);
        this.ldr.getMetadataReader().setIsRequired(true);
        this.ldr.getMetadataWriter().setDepth(1);
    }

    @Override
    public void commence() {
        this.addProcessor(new PropertyInjector().setKey("GzipDecoderBypass.IsGzipped").setValue(Boolean.TRUE));
        this.addProcessor(this.ldr);
        super.commence();
    }

    public static class EntryLoader
    extends TableCellHandlerBase<GzipIndex> {
        GzipIndexEntry entry;

        @Override
        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, GzipIndex po) throws Exception {
            if (1L == meta.getColumnNumber()) {
                this.entry = new GzipIndexEntry();
            }
            long data = Long.parseLong(cellData.toString());
            switch ((int)meta.getColumnNumber()) {
                case 1: {
                    this.entry.setKeyValue(data);
                }
                case 3: {
                    this.entry.setByteOffset(data);
                }
            }
            if (meta.isEndOfLine()) {
                po.addEntry(this.entry);
            }
            return false;
        }

        @Override
        public boolean endTable(Bucket<GzipIndex> bo) throws Exception {
            bo.getPayload().materialize(false);
            return super.endTable(bo);
        }

        @Override
        public void clear() {
            this.entry = null;
        }
    }

    public static class IndexPayloadManager
    extends PayloadManager.DisposablePayloadManager<GzipIndex> {
        @Override
        public GzipIndex newPayload() {
            return new GzipIndex();
        }
    }

    public static class Parser
    extends TableParser {
        public Parser() {
            this.setPayloadManager(new IndexPayloadManager());
        }

        protected TableParsingLogic newLogic() {
            return new WhiteSpaceParsingLogic();
        }

        protected TableCellHandler newHandler() {
            return new EntryLoader();
        }
    }
}

