/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip.index;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.parser.ListTransformer;

public class GzipIndexMetadataTransformer
extends ListTransformer {
    public GzipIndexMetadataTransformer() {
        this.setPayloadManager(new CollectionFactory.ListFactory().setReuse(false));
    }

    @Override
    public Object transform(Object o) {
        Map m = (Map)o;
        long[] array = new long[4];
        Integer ci = (Integer)m.get("Splitter.ChunkIndex");
        array[0] = ci + 1;
        Integer ro = (Integer)m.get("Splitter.RecordOffset");
        array[1] = ro + 1;
        array[2] = (Long)m.get("GzipEncoder.BytesRead");
        AtomicLong gzl = (AtomicLong)m.get("StreamLengthCalculator.Length");
        array[3] = gzl.longValue();
        return array;
    }

    @Override
    public void transform(Contract c, List payloadIn, List payloadOut, boolean endOfContract) {
        super.transform(c, payloadIn, payloadOut, endOfContract);
        if (endOfContract) {
            Long recordCount = (Long)c.get("Splitter.RecordCount");
            if (recordCount == null) {
                throw new NullPointerException();
            }
            long[] backstop = new long[]{-1L, recordCount, 0L, 0L};
            payloadOut.add(backstop);
        }
    }
}

