/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.gzip.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.contracts.Demultiplexer;
import uk.ac.ox.well.t2d.async.processors.BucketBase;

public class MetadataBranch<PI>
extends Demultiplexer<PI> {
    public Map<String, Context> cxtMap = new LinkedHashMap<String, Context>();
    protected Processor<Map> metaProcessor;
    protected int maxBatchSize = 1000;

    public MetadataBranch setMetadataProcessor(Processor<Map> p) {
        this.metaProcessor = p;
        return this;
    }

    public MetadataBranch setMaxSize(int mxsz) {
        this.maxBatchSize = mxsz;
        return this;
    }

    @Override
    public synchronized void consume(Contract c, Bucket<PI> bin, boolean endOfInput) {
        if (!(c instanceof ContractGroup.SiblingContract)) {
            c.fail(new ClassCastException("Expecting a SiblingContract. found: " + c.getClass()));
        }
        ContractGroup.SiblingContract sc = (ContractGroup.SiblingContract)c;
        ContractGroup grp = sc.getGroup();
        if (endOfInput) {
            grp.complete(sc);
        }
        boolean parentEndOfInput = grp.isCompleted();
        Context cxt = this.getContext(c.getSuperContract());
        cxt.consume(sc, bin, endOfInput, parentEndOfInput);
        if (parentEndOfInput) {
            this.removeContext(c.getSuperContract());
        }
    }

    protected synchronized Context getContext(Contract parent) {
        Context cxt = this.cxtMap.get(parent.getId());
        if (null == cxt) {
            cxt = this.newContext(parent);
            this.cxtMap.put(parent.getId(), cxt);
        }
        return cxt;
    }

    protected synchronized void removeContext(Contract parent) {
        this.cxtMap.remove(parent.getId());
    }

    protected Context newContext(Contract parent) {
        return new Context(parent);
    }

    protected class Context {
        ContractGroup.SiblingContract coreContract;
        ContractGroup.SiblingContract metaContract;
        ArrayList<Map> batcher;

        public Context(Contract parent) {
            ContractGroup grp = new ContractGroup(parent);
            this.coreContract = grp.newContract(false);
            this.metaContract = grp.newContract(true);
            this.batcher = new ArrayList();
        }

        public void consume(ContractGroup.SiblingContract sc, Bucket bin, boolean subContractEndOfStream, boolean parentContractEndOfStream) {
            MetadataBranch.this.processor.consume(this.coreContract, bin, parentContractEndOfStream);
            if (subContractEndOfStream) {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.putAll(sc);
                this.batcher.add(hm);
            }
            if (parentContractEndOfStream || MetadataBranch.this.maxBatchSize > 0 && MetadataBranch.this.maxBatchSize <= this.batcher.size()) {
                MetadataBranch.this.metaProcessor.consume(this.metaContract, new BucketBase<ArrayList<Map>>(this.batcher), parentContractEndOfStream);
                this.batcher = new ArrayList();
            }
        }
    }
}

