/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Command;

public abstract class AbstractFileChannelContext<PI>
implements CompletionHandler<Integer, Attachment> {
    protected int position = 0;
    protected AsynchronousFileChannel channel = null;
    protected Attachment attachment = new Attachment();

    protected abstract Set<StandardOpenOption> getOpenOptions();

    protected abstract ExecutorService getExecutorService();

    protected abstract void performChannelOperation(ByteBuffer var1, int var2, Attachment var3);

    protected abstract void processingCompleted(Command<PI> var1, Bucket<ByteBuffer> var2, boolean var3);

    protected abstract void processingCancelled(Command<PI> var1, Bucket<ByteBuffer> var2, Throwable var3, String var4);

    protected AsynchronousFileChannel getChannel() {
        return this.channel;
    }

    protected void initialize(Path p) throws IOException {
        if (null == this.channel) {
            this.channel = AsynchronousFileChannel.open(p, this.getOpenOptions(), this.getExecutorService(), new FileAttribute[0]);
            this.position = 0;
            this.attachment.clear();
        }
    }

    public void performChannelOperation(Command<PI> command, Bucket<ByteBuffer> bucket) {
        this.attachment.setBucket(bucket);
        this.attachment.setCommand(command);
        this.performChannelOperation(bucket.getPayload(), this.position, this.attachment);
    }

    @Override
    public void completed(Integer result, Attachment a) {
        boolean inputComplete = false;
        if (-1 == result) {
            inputComplete = true;
        } else {
            this.position += result.intValue();
        }
    }

    @Override
    public void failed(Throwable exc, Attachment a) {
        this.processingCancelled(a.getCommand(), a.getBucket(), exc, "Failed to execute asynchronous file operation");
    }

    public class Attachment {
        private Command<PI> command;
        private Bucket<ByteBuffer> bucket;

        public void clear() {
            this.command = null;
            this.bucket = null;
        }

        public Command<PI> getCommand() {
            return this.command;
        }

        public void setCommand(Command<PI> command) {
            this.command = command;
        }

        public Bucket<ByteBuffer> getBucket() {
            return this.bucket;
        }

        public void setBucket(Bucket<ByteBuffer> bucket) {
            this.bucket = bucket;
        }
    }
}

