/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.Set;
import uk.ac.ox.well.t2d.async.Command;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.io.BufferConfigurable;
import uk.ac.ox.well.t2d.async.io.ByteBufferFactory;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class AsynchronousFileChannelReader
extends AbstractConveyor
implements BufferConfigurable {
    public static Set<StandardOpenOption> READ_ONLY = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.READ));

    public AsynchronousFileChannelReader() {
        this.setPayloadManager(new ByteBufferFactory());
    }

    public ByteBufferFactory getPayloadFactory() {
        return (ByteBufferFactory)this.payloadManager;
    }

    protected FileChannelContext newContext() {
        return new FileChannelContext();
    }

    @Override
    public void setBufferCapacity(int bufferCapacity) {
        this.getPayloadFactory().setCapacity(bufferCapacity);
    }

    public static class FileSectionOutOfBoundsException
    extends Exception {
        long actualLength;
        Path path;
        long start;
        long end;

        public FileSectionOutOfBoundsException(long alen, Path p, long st, long en) {
            this.actualLength = alen;
            this.path = p;
            this.start = st;
            this.end = en;
        }

        @Override
        public String getMessage() {
            Formatter f = new Formatter();
            f.format("Required FileSection with Path '%s', Start %,d, End %,d is out of bounds. Found file with actual length %,d.", this.path, this.start, this.end, this.actualLength);
            return f.toString();
        }
    }

    public static class FileSection {
        private Path path;
        private long start;
        private long end;

        public long getStart() {
            return this.start;
        }

        public FileSection setStart(long start) {
            this.start = start;
            return this;
        }

        public long getEnd() {
            return this.end;
        }

        public FileSection setEnd(long end) {
            this.end = end;
            return this;
        }

        public Path getPath() {
            return this.path;
        }

        public FileSection setPath(Path path) {
            this.path = path;
            return this;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("FileSection: Path '%s', Start %,d, End %,d", this.path, this.start, this.end);
            return f.toString();
        }
    }

    public class FileChannelContext
    extends ProcessingContext<Object, ByteBuffer>
    implements CompletionHandler<Integer, Command<Path>> {
        Path path = null;
        long start = 0L;
        long end = 0L;
        long position = 0L;
        AsynchronousFileChannel channel = null;

        @Override
        protected void initialize() throws Exception {
            Object payload = this.getPayloadIn().getPayload();
            if (null == payload) {
                throw new NullPointerException("Not expecting a Null Payload. Expecting a String, File, Path or FileSection");
            }
            if (payload instanceof File) {
                File f = (File)payload;
                payload = f.toPath();
            } else if (payload instanceof String) {
                String str = (String)payload;
                payload = Paths.get(str, new String[0]);
            }
            if (payload instanceof Path) {
                this.path = (Path)payload;
                this.start = 0L;
                this.end = Files.size(this.path);
            } else if (payload instanceof FileSection) {
                FileSection fs = (FileSection)payload;
                this.path = fs.getPath();
                this.start = fs.getStart();
                this.end = fs.getEnd();
            } else {
                throw new ClassCastException("Expecting a String, File, Path or FileSection. Found: " + payload.getClass());
            }
            long length = Files.size(this.path);
            if (this.start < 0L || this.end > length) {
                throw new FileSectionOutOfBoundsException(length, this.path, this.start, this.end);
            }
            this.channel = AsynchronousFileChannel.open(this.path, READ_ONLY, AsynchronousFileChannelReader.this.getExecutorService(), new FileAttribute[0]);
            this.position = this.start;
        }

        @Override
        public ProcessingResult process() throws Exception {
            this.channel.read((ByteBuffer)this.getPayloadOut().getPayload(), this.position, null, this);
            return ProcessingResult.NEITHER_COMPLETE;
        }

        @Override
        public void completed(Integer result, Command<Path> cmd) {
            ProcessingResult pr = ProcessingResult.OUTPUT_COMPLETE;
            long currentPosition = this.position + (long)result.intValue();
            if (-1 == result || this.end == currentPosition) {
                pr = ProcessingResult.BOTH_COMPLETE;
            } else if (currentPosition > this.end) {
                pr = ProcessingResult.BOTH_COMPLETE;
                int overhang = (int)(currentPosition - this.end);
                ByteBuffer bb = (ByteBuffer)this.getPayloadOut().getPayload();
                bb.limit(bb.position() - overhang);
            } else {
                this.position = currentPosition;
            }
            ((ByteBuffer)this.getPayloadOut().getPayload()).flip();
            AsynchronousFileChannelReader.this.processingCompleted(pr, this);
        }

        @Override
        public void failed(Throwable exc, Command<Path> cmd) {
            AsynchronousFileChannelReader.this.processingFailed(this, exc);
        }
    }
}

