/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import uk.ac.ox.well.t2d.async.Command;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.io.IOProperties;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class AsynchronousFileChannelWriter
extends AbstractConveyor<FileChannelContext, ByteBuffer, FileWriteResult> {
    public static final Set<StandardOpenOption> CREATE_OR_WRITE = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
    protected Set<StandardOpenOption> openOptions = CREATE_OR_WRITE;
    protected boolean closeChannels = true;

    @Override
    protected FileChannelContext newContext() {
        return new FileChannelContext();
    }

    protected class FileChannelContext
    extends ProcessingContext<ByteBuffer, FileWriteResult>
    implements CompletionHandler<Integer, Command<ByteBuffer>> {
        long position = 0L;
        Path path = null;
        AsynchronousFileChannel channel = null;

        @Override
        public void clear() {
            super.clear();
            this.position = 0L;
            this.path = null;
            if (AsynchronousFileChannelWriter.this.closeChannels) {
                try {
                    this.channel.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            this.channel = null;
        }

        @Override
        protected void initialize() throws Exception {
            Object pathObj = this.getContract().get("IOProperties.OUT_PATH");
            if (null == pathObj) {
                throw new NullPointerException("Cannot initialize output path, property IOProperties.OUT_PATH not found.");
            }
            if (pathObj instanceof Path) {
                this.path = (Path)pathObj;
            } else if (pathObj instanceof String) {
                this.path = IOProperties.toPath(this.getContract(), pathObj.toString());
            } else {
                throw new IllegalArgumentException("Cannot initialize output path, not expecting an object of class: " + pathObj.getClass());
            }
            this.createParentDirectories(this.path);
            this.channel = this.openChannel(this.path);
            this.position = 0L;
        }

        protected void createParentDirectories(Path p) throws IOException {
            IOProperties.createParentDirectories(p);
        }

        protected AsynchronousFileChannel openChannel(Path p) throws IOException {
            return AsynchronousFileChannel.open(p, AsynchronousFileChannelWriter.this.openOptions, AsynchronousFileChannelWriter.this.getExecutorService(), new FileAttribute[0]);
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, FileWriteResult po, boolean endOfContract) throws Exception {
            this.channel.write(pi, this.position, null, this);
            return ProcessingResult.NEITHER_COMPLETE;
        }

        @Override
        public void completed(Integer result, Command<ByteBuffer> cmd) {
            this.position += (long)result.intValue();
            if (this.isEndOfContract()) {
                this.getPayloadOut().setPayload(new FileWriteResult(this.path, this.position));
                AsynchronousFileChannelWriter.this.processingCompleted(ProcessingResult.BOTH_COMPLETE, this);
            } else {
                AsynchronousFileChannelWriter.this.processingCompleted(ProcessingResult.INPUT_COMPLETE, this);
            }
        }

        @Override
        public void failed(Throwable exc, Command<ByteBuffer> cmd) {
            AsynchronousFileChannelWriter.this.processingFailed(this, exc);
        }
    }

    public static class FileWriteResult {
        private Path path;
        private long size;

        public FileWriteResult(Path p, long s) {
            this.path = p;
            this.size = s;
        }

        public Path getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public String toString() {
            return this.getSize() + " : " + this.getPath();
        }
    }
}

