/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.nio.ByteBuffer;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.io.BufferConfigurable;
import uk.ac.ox.well.t2d.async.io.ByteBufferFactory;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class ByteBufferCopier
extends AbstractConveyor<Context, ByteBuffer, ByteBuffer>
implements BufferConfigurable {
    public ByteBufferCopier() {
        this.setPayloadManager(new ByteBufferFactory());
    }

    public ByteBufferFactory getPayloadFactory() {
        return (ByteBufferFactory)this.payloadManager;
    }

    @Override
    public void setBufferCapacity(int bufferCapacity) {
        this.getPayloadFactory().setCapacity(bufferCapacity);
    }

    public ByteBufferCopier setAllocateDirect(boolean allocateDirect) {
        this.getPayloadFactory().setAllocateDirect(allocateDirect);
        return this;
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    protected class Context
    extends ProcessingContext<ByteBuffer, ByteBuffer> {
        long counter = 0L;

        @Override
        public void clear() {
            super.clear();
            this.counter = 0L;
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, ByteBuffer po, boolean endOfContract) throws Exception {
            while (pi.hasRemaining() && po.hasRemaining()) {
                po.put(pi.get());
                ++this.counter;
            }
            if (!(pi.hasRemaining() || po.hasRemaining() && !endOfContract)) {
                po.flip();
                return ProcessingResult.BOTH_COMPLETE;
            }
            if (!pi.hasRemaining()) {
                return ProcessingResult.INPUT_COMPLETE;
            }
            po.flip();
            return ProcessingResult.OUTPUT_COMPLETE;
        }
    }
}

