/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.io.SubContractor;
import uk.ac.ox.well.t2d.async.processors.PayloadMulticaster;

public class ByteBufferMulticaster
implements Processor<ByteBuffer> {
    public Map<String, Context> cxtMap = new LinkedHashMap<String, Context>();
    protected Map<SubContractor, Processor<ByteBuffer>> processorMap = new LinkedHashMap<SubContractor, Processor<ByteBuffer>>();

    public void addProcessor(Processor<ByteBuffer> p, SubContractor sc) {
        this.processorMap.put(sc, p);
    }

    @Override
    public void commence() {
        for (Processor<ByteBuffer> p : this.processorMap.values()) {
            p.commence();
        }
    }

    @Override
    public void close() {
        for (Processor<ByteBuffer> p : this.processorMap.values()) {
            p.close();
        }
        this.cxtMap.clear();
        this.processorMap.clear();
    }

    @Override
    public void consume(Contract c, Bucket<ByteBuffer> bin, boolean endOfStream) {
        Context cxt = this.getContext(c);
        cxt.multiplex(bin, endOfStream);
        if (endOfStream) {
            this.removeContext(c);
        }
    }

    protected synchronized Context getContext(Contract parent) {
        Context cxt = this.cxtMap.get(parent.getId());
        if (null == cxt) {
            cxt = this.newContext(parent);
            this.cxtMap.put(parent.getId(), cxt);
        }
        return cxt;
    }

    protected Context newContext(Contract parent) {
        Context cxt = new Context();
        ContractGroup grp = new ContractGroup(parent);
        Iterator<Map.Entry<SubContractor, Processor<ByteBuffer>>> it = this.processorMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SubContractor, Processor<ByteBuffer>> entry = it.next();
            boolean finalize = !it.hasNext();
            ContractGroup.SiblingContract sub = grp.newContract(finalize);
            entry.getKey().setup(sub);
            cxt.addSubContract(sub, entry.getValue());
        }
        return cxt;
    }

    protected synchronized void removeContext(Contract parent) {
        this.cxtMap.remove(parent.getId());
    }

    public class ByteBufferBucketMultiplexer
    extends PayloadMulticaster<ByteBuffer> {
        public ByteBufferBucketMultiplexer(Bucket<ByteBuffer> bb, int size) {
            super(bb, size);
        }

        @Override
        public ByteBuffer multiplexPayload(ByteBuffer bb, int i) {
            return bb.duplicate();
        }
    }

    protected class Context {
        Map<Contract, Processor<ByteBuffer>> map = new LinkedHashMap<Contract, Processor<ByteBuffer>>();

        public void addSubContract(Contract sc, Processor<ByteBuffer> p) {
            this.map.put(sc, p);
        }

        public void multiplex(Bucket<ByteBuffer> bin, boolean endOfStream) {
            ByteBufferBucketMultiplexer bbbm = new ByteBufferBucketMultiplexer(bin, this.map.size());
            Iterator cit = bbbm.iterator();
            for (Map.Entry<Contract, Processor<ByteBuffer>> entry : this.map.entrySet()) {
                entry.getValue().consume(entry.getKey(), cit.next(), endOfStream);
            }
        }
    }
}

