/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.io.ByteBufferFactory;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class ChannelReader
extends AbstractConveyor<ChannelReaderContext, ReadableByteChannel, ByteBuffer> {
    public ChannelReader() {
        this.setPayloadManager(new ByteBufferFactory());
    }

    @Override
    protected ChannelReaderContext newContext() {
        return new ChannelReaderContext();
    }

    protected class ChannelReaderContext
    extends ProcessingContext<ReadableByteChannel, ByteBuffer> {
        protected ChannelReaderContext() {
        }

        @Override
        public ProcessingResult process() throws Exception {
            return this.process(this, this.getContract(), (ReadableByteChannel)this.getPayloadIn().getPayload(), (ByteBuffer)this.getPayloadOut().getPayload(), this.isEndOfContract());
        }

        public ProcessingResult process(ProcessingContext cxt, Contract c, ReadableByteChannel channel, ByteBuffer buffer, boolean endOfInput) {
            try {
                buffer.clear();
                int bytesRead = channel.read(buffer);
                if (-1 == bytesRead) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        c.fail(e);
                        return ProcessingResult.FAILURE;
                    }
                    return ProcessingResult.BOTH_COMPLETE;
                }
                buffer.flip();
                return ProcessingResult.OUTPUT_COMPLETE;
            }
            catch (ClosedChannelException cce) {
                c.fail(cce);
                return ProcessingResult.FAILURE;
            }
            catch (IOException e) {
                try {
                    channel.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                c.fail(e);
                return ProcessingResult.FAILURE;
            }
        }

        public void commence() {
        }

        public void close() {
        }
    }
}

