/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.io.BufferConfigurable;
import uk.ac.ox.well.t2d.async.io.CharBufferFactory;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class CharacterDecoder
extends AbstractConveyor<DecoderContext, ByteBuffer, CharBuffer>
implements BufferConfigurable {
    public static final String CHARACTER_SET = "CharacterDecoder.Charset";
    protected Charset defaultCharset;

    public CharacterDecoder() {
        this.setPayloadManager(new CharBufferFactory());
        this.defaultCharset = Charset.defaultCharset();
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public CharBufferFactory getPayloadFactory() {
        return (CharBufferFactory)this.payloadManager;
    }

    @Override
    public void setBufferCapacity(int bufferCapacity) {
        this.getPayloadFactory().setCapacity(bufferCapacity);
    }

    @Override
    protected DecoderContext newContext() {
        return new DecoderContext();
    }

    protected class DecoderContext
    extends ProcessingContext<ByteBuffer, CharBuffer> {
        Charset cs = null;
        CharsetDecoder decoder = null;
        private long charCount = 0L;

        @Override
        public ProcessingResult process() throws Exception {
            try {
                return this.decode((ByteBuffer)this.getPayloadIn().getPayload(), (CharBuffer)this.getPayloadOut().getPayload(), this.isEndOfContract());
            }
            catch (CharacterCodingException cce) {
                this.getContract().getLogger().error("Trouble while decoding byte data", cce);
                this.getContract().fail(cce);
                return ProcessingResult.FAILURE;
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.cs = null;
            this.decoder = null;
            this.charCount = 0L;
        }

        @Override
        protected void initialize() {
            this.cs = CharacterDecoder.this.getDefaultCharset();
            String value = (String)this.getContract().get(CharacterDecoder.CHARACTER_SET);
            if (null != value) {
                this.cs = Charset.forName(value);
            }
            this.decoder = this.cs.newDecoder();
            this.charCount = 0L;
        }

        public long getCharCount() {
            return this.charCount;
        }

        protected ProcessingResult decode(ByteBuffer pi, CharBuffer po, boolean endOfInput) throws CharacterCodingException {
            po.clear();
            CoderResult result = this.decoder.decode(pi, po, endOfInput);
            boolean inBufComplete = this.handleCoderResult(result);
            if (endOfInput && inBufComplete) {
                inBufComplete = this.flush(po);
            }
            this.prepBufferForReading(po);
            if (inBufComplete) {
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.OUTPUT_COMPLETE;
        }

        protected boolean flush(CharBuffer po) throws CharacterCodingException {
            CoderResult result = this.decoder.flush(po);
            return this.handleCoderResult(result);
        }

        protected boolean handleCoderResult(CoderResult result) throws CharacterCodingException {
            if (result.isUnderflow() || result.isOverflow()) {
                return result.isUnderflow();
            }
            result.throwException();
            assert (false);
            throw new RuntimeException("Expected CoderResult to throwException, it didn't: " + result);
        }

        protected void prepBufferForReading(CharBuffer po) {
            this.charCount += (long)po.position();
            po.flip();
        }
    }
}

