/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.io.BufferConfigurable;
import uk.ac.ox.well.t2d.async.io.ByteBufferFactory;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class CharacterEncoder
extends AbstractConveyor<EncoderContext, CharBuffer, ByteBuffer>
implements BufferConfigurable {
    public static final String CHARACTER_SET = "CharacterEncoder.Charset";
    protected Charset defaultCharset;

    public CharacterEncoder() {
        this.setPayloadManager(new ByteBufferFactory());
        this.defaultCharset = Charset.defaultCharset();
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public ByteBufferFactory getPayloadFactory() {
        return (ByteBufferFactory)this.payloadManager;
    }

    @Override
    public void setBufferCapacity(int bufferCapacity) {
        this.getPayloadFactory().setCapacity(bufferCapacity);
    }

    @Override
    protected EncoderContext newContext() {
        return new EncoderContext();
    }

    protected class EncoderContext
    extends ProcessingContext<CharBuffer, ByteBuffer> {
        Charset cs = null;
        CharsetEncoder encoder = null;
        private long byteCount = 0L;

        @Override
        public ProcessingResult process() throws Exception {
            try {
                return this.encode((CharBuffer)this.getPayloadIn().getPayload(), (ByteBuffer)this.getPayloadOut().getPayload(), this.isEndOfContract());
            }
            catch (CharacterCodingException cce) {
                this.getContract().getLogger().error("Trouble while encoding byte data", cce);
                this.getContract().fail(cce);
                return ProcessingResult.FAILURE;
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.cs = null;
            this.encoder = null;
            this.byteCount = 0L;
        }

        @Override
        protected void initialize() {
            this.cs = CharacterEncoder.this.getDefaultCharset();
            String value = (String)this.getContract().get(CharacterEncoder.CHARACTER_SET);
            if (null != value) {
                this.cs = Charset.forName(value);
            }
            this.encoder = this.cs.newEncoder();
            this.byteCount = 0L;
        }

        public long getByteCount() {
            return this.byteCount;
        }

        protected ProcessingResult encode(CharBuffer pi, ByteBuffer po, boolean endOfInput) throws CharacterCodingException {
            po.clear();
            CoderResult result = this.encoder.encode(pi, po, endOfInput);
            boolean inBufComplete = this.handleCoderResult(result);
            if (endOfInput && inBufComplete) {
                inBufComplete = this.flush(po);
            }
            this.prepBufferForReading(po);
            if (inBufComplete) {
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.OUTPUT_COMPLETE;
        }

        protected boolean flush(ByteBuffer po) throws CharacterCodingException {
            CoderResult result = this.encoder.flush(po);
            return this.handleCoderResult(result);
        }

        protected boolean handleCoderResult(CoderResult result) throws CharacterCodingException {
            if (result.isUnderflow() || result.isOverflow()) {
                return result.isUnderflow();
            }
            result.throwException();
            assert (false);
            throw new RuntimeException("Expected CoderResult to throwException, it didn't: " + result);
        }

        protected void prepBufferForReading(ByteBuffer po) {
            this.byteCount += (long)po.position();
            po.flip();
        }
    }
}

