/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class Checksummer
extends AbstractConveyor<ChecksumContext, ByteBuffer, ChecksumResult> {
    @Override
    protected ChecksumContext newContext() {
        return new ChecksumContext();
    }

    protected void validate(ChecksumResult result) {
    }

    protected class ChecksumContext
    extends ProcessingContext<ByteBuffer, ChecksumResult> {
        Checksum cksum = null;
        long length = 0L;

        @Override
        public void clear() {
            super.clear();
            this.cksum = null;
            this.length = 0L;
        }

        @Override
        protected void initialize() {
            this.cksum = this.newInstance();
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<ChecksumResult> bo, boolean endOfContract) throws Exception {
            this.cksum.update(pi.array(), pi.arrayOffset(), pi.arrayOffset() + pi.limit());
            this.length += (long)pi.limit();
            if (endOfContract) {
                ChecksumResult cksr = new ChecksumResult(this.cksum.getValue(), this.length);
                bo.setPayload(cksr);
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        protected final Checksum newInstance() {
            return new CRC32();
        }
    }

    public static class ChecksumResult {
        long cksum;
        long size;

        public ChecksumResult(long ck, long sz) {
            this.cksum = ck;
            this.size = sz;
        }

        public long getSize() {
            return this.size;
        }

        public long getChecksum() {
            return this.cksum;
        }

        public String toString() {
            return "CRC32:" + this.getSize() + ":" + this.getChecksum();
        }
    }
}

