/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.UnexpectedPayloadException;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.processors.PayloadManager;

public class DirectoryScanner
extends AbstractConveyor<Context, Object, Collection<Path>> {
    protected Integer maxDepth = Integer.MAX_VALUE;

    public DirectoryScanner() {
        this.setPayloadManager(new PayloadManager<Collection<Path>>(){

            @Override
            public Collection<Path> newPayload() {
                return new ArrayList<Path>();
            }

            @Override
            public Collection<Path> resetPayload(Collection<Path> p) {
                p.clear();
                return p;
            }
        });
    }

    public DirectoryScanner setMaxDepth(Integer i) {
        this.maxDepth = i;
        if (0 == this.maxDepth) {
            this.logger.warn("DirectoryScanner. MaxDepth is set to 0, which will return no results.");
        }
        return this;
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    public static class DirVisitor
    implements FileVisitor<Path> {
        Path root;
        Set<Path> paths = new TreeSet<Path>();

        public DirVisitor setRootDir(Path p) {
            this.root = p;
            return this;
        }

        public Set<Path> getPaths() {
            return this.paths;
        }

        public void clear() {
            this.paths.clear();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
            return this.handleVisit(file, attrs);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            return this.handleVisit(file, attrs);
        }

        public FileVisitResult handleVisit(Path file, BasicFileAttributes attrs) {
            if (attrs.isDirectory() && !this.root.equals(file)) {
                if (file.getFileName().startsWith(".svn")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                this.paths.add(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public class Context
    extends ProcessingContext<Object, Collection<Path>> {
        DirVisitor scanner = new DirVisitor();

        @Override
        public ProcessingResult process(Object pi, Collection<Path> po, boolean endOfContract) throws Exception {
            Path dir = null;
            if (null == pi) {
                throw new UnexpectedPayloadException("Directory Scanner does not expect a Null payload");
            }
            if (pi instanceof Path) {
                dir = (Path)pi;
            } else if (pi instanceof String) {
                dir = Paths.get((String)pi, new String[0]);
            } else {
                throw new UnexpectedPayloadException("Directory Scanner expects a Path or a String as input. Found: " + pi.getClass());
            }
            this.scanner.setRootDir(dir);
            Files.walkFileTree(dir, Collections.EMPTY_SET, DirectoryScanner.this.maxDepth, this.scanner);
            po.addAll(this.scanner.getPaths());
            this.scanner.clear();
            return ProcessingResult.BOTH_COMPLETE;
        }
    }
}

