/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import uk.ac.ox.well.t2d.async.Contract;

public class IOProperties {
    public static final String EXTENSION_SEPARATOR = ".";
    public static final String BASE_DIR = "IOProperties.BASE_DIR";
    public static final String IN_STEM = "IOProperties.IN_STEM";
    public static final String IN_DIRECTORY = "IOProperties.IN_DIRECTORY";
    public static final String IN_PATH = "IOProperties.IN_PATH";
    public static final String IN_SUFFIX = "IOProperties.IN_SUFFIX";
    public static final String IN_PREFIX = "IOProperties.IN_PREFIX";
    public static final String OUT_STEM = "IOProperties.OUT_STEM";
    public static final String OUT_DIRECTORY = "IOProperties.OUT_DIRECTORY";
    public static final String OUT_PATH = "IOProperties.OUT_PATH";
    public static final String OUT_SUFFIX = "IOProperties.OUT_SUFFIX";
    public static final String OUT_PREFIX = "IOProperties.OUT_PREFIX";
    public static final String NAME_COMPONENT_SEPARATOR = "IOProperties.NAME_COMPONENT_SEPARATOR";
    public static final String WORKING_DIR = "IOProperties.WORKING_DIR";
    public static final String DELETE_WORKING_FILES = "IOProperties.DELETE_WORKING_FILES";

    public static Path getBaseDir(Contract c) {
        String baseDirStr = (String)c.get(BASE_DIR);
        if (null == baseDirStr || baseDirStr.isEmpty()) {
            return null;
        }
        Path baseDir = Paths.get(baseDirStr, new String[0]);
        if (!Files.isDirectory(baseDir, new LinkOption[0])) {
            throw new RuntimeException("Expecting BaseDirectory to be a directory. It is not. Found: " + baseDir);
        }
        return baseDir;
    }

    public static Path toPath(Path baseDir, String path) {
        if (null == baseDir) {
            Path p = Paths.get(path, new String[0]);
            return p;
        }
        Path p = baseDir.resolve(path);
        return p;
    }

    public static Path toPath(Contract c, String path) {
        Path bd = IOProperties.getBaseDir(c);
        return IOProperties.toPath(bd, path);
    }

    public static boolean pathExists(Contract c, String path) {
        Path p = IOProperties.toPath(c, path);
        return Files.exists(p, new LinkOption[0]);
    }

    public static void createParentDirectories(Path filePath) throws IOException {
        Path parentPath = filePath.getParent();
        Files.createDirectories(parentPath, new FileAttribute[0]);
    }

    public static String getLabelFromPath(Path p) {
        String name = p.getFileName().toString();
        if (!name.contains(EXTENSION_SEPARATOR)) {
            return name;
        }
        int i = name.lastIndexOf(EXTENSION_SEPARATOR);
        return name.substring(0, i);
    }
}

