/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class MessageDigester
extends AbstractConveyor<DigesterContext, ByteBuffer, MessageDigestResult> {
    public static final String DIGEST_ALGORTHM_PROPERTY = "MessageDigester.Algorithm";
    protected String defaultAlgorithm = "SHA";

    public String getDefaultAlgorithm() {
        return this.defaultAlgorithm;
    }

    public void setDefaultAlgorithm(String defaultAlgorithm) {
        this.defaultAlgorithm = defaultAlgorithm;
    }

    public static String toHex(byte[] digest) {
        return DatatypeConverter.printHexBinary((byte[])digest).toLowerCase();
    }

    @Override
    protected DigesterContext newContext() {
        return new DigesterContext();
    }

    protected class DigesterContext
    extends ProcessingContext<ByteBuffer, MessageDigestResult> {
        String algorithm = null;
        MessageDigest digester = null;
        long length = 0L;

        @Override
        public void clear() {
            super.clear();
            this.algorithm = null;
            this.digester = null;
            this.length = 0L;
        }

        @Override
        protected void initialize() {
            this.algorithm = MessageDigester.this.getDefaultAlgorithm();
            String value = (String)this.getContract().get(MessageDigester.DIGEST_ALGORTHM_PROPERTY);
            if (null != value) {
                this.algorithm = value;
            }
            this.digester = this.newDigestInstance(this.algorithm);
        }

        @Override
        public ProcessingResult process(ByteBuffer pi, Bucket<MessageDigestResult> bo, boolean endOfContract) throws Exception {
            this.digester.update(pi.array(), pi.arrayOffset(), pi.arrayOffset() + pi.limit());
            this.length += (long)pi.limit();
            if (endOfContract) {
                MessageDigestResult mdr = new MessageDigestResult(this.digester.getAlgorithm(), this.digester.digest(), this.length);
                bo.setPayload(mdr);
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        protected final MessageDigest newDigestInstance(String algo) {
            try {
                return MessageDigest.getInstance(algo);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException(nsae);
            }
        }
    }

    public static class MessageDigestResult {
        private String algorithm;
        private byte[] digest;
        long size;

        public MessageDigestResult(String algo, byte[] ba, long len) {
            this.algorithm = algo;
            this.digest = ba;
            this.size = len;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public byte[] getDigest() {
            return this.digest;
        }

        public long getSize() {
            return this.size;
        }

        public String getHexDigest() {
            return MessageDigester.toHex(this.digest);
        }

        public String toString() {
            return this.getAlgorithm() + ":" + this.getSize() + ":" + this.getHexDigest();
        }
    }
}

