/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.nio.file.Path;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.io.IOProperties;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class PathFinder
extends AbstractConveyor<Context, Object, Path> {
    protected int depth;

    public PathFinder setDepth(int i) {
        this.depth = i;
        return this;
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    protected Contract resolveContract(Contract c) {
        Contract thisContract = c;
        for (int i = 0; i < this.depth; ++i) {
            if (null == thisContract.getSuperContract()) {
                throw new RuntimeException("Queue Contract Depth set to " + this.depth + ". However there were not enough ancestor Contracts to " + "satisfy that requirement. Failed at depth " + i + ".");
            }
            thisContract = thisContract.getSuperContract();
        }
        return thisContract;
    }

    public class Context
    extends ProcessingContext<Object, Path> {
        Path baseDir;

        @Override
        protected void initialize() throws Exception {
            this.baseDir = IOProperties.getBaseDir(this.getContract());
        }

        @Override
        public ProcessingResult process(Object pi, Bucket<Path> po, boolean endOfContract) throws Exception {
            Path path = this.resolvePath(pi);
            po.setPayload(path);
            Contract c = PathFinder.this.resolveContract(this.getContract());
            c.put("IOProperties.IN_PATH", path);
            return ProcessingResult.BOTH_COMPLETE;
        }

        public Path resolvePath(Object o) {
            Path path = o instanceof Path ? (Path)o : this.toPath(o.toString());
            return path;
        }

        public Path toPath(String pathStr) {
            return IOProperties.toPath(this.baseDir, pathStr);
        }

        @Override
        public void clear() {
            this.baseDir = null;
        }
    }
}

