/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.UnexpectedPayloadException;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class PathScanner
extends AbstractConveyor<Context, Object, Collection<Path>> {
    List<String> patterns = new ArrayList<String>();
    Integer maxDepth = Integer.MAX_VALUE;

    public PathScanner() {
        this.setPayloadManager(new CollectionFactory.ListFactory().setReuse(false));
    }

    public void addPattern(String pattern) {
        if (!pattern.startsWith("glob:") && !pattern.startsWith("regex:")) {
            throw new RuntimeException("Patterns should start with 'glob:' or 'regex:'. Found: " + pattern);
        }
        this.patterns.add(pattern);
    }

    public List<String> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public void setMaxDepth(Integer i) {
        this.maxDepth = i;
    }

    @Override
    protected Context newContext() {
        return new Context();
    }

    public class Scanner
    implements FileVisitor<Path> {
        List<PathMatcher> matchers = new ArrayList<PathMatcher>();
        Set<Path> paths = new TreeSet<Path>();

        public void addMatcher(PathMatcher pm) {
            this.matchers.add(pm);
        }

        public Set<Path> getMatchingPaths() {
            return this.paths;
        }

        public void clear() {
            this.matchers.clear();
            this.paths.clear();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            for (PathMatcher pm : this.matchers) {
                if (!pm.matches(file)) continue;
                this.paths.add(file);
                break;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    public class Context
    extends ProcessingContext<Object, Collection<Path>> {
        Scanner scanner;

        public Context() {
            this.scanner = new Scanner();
        }

        @Override
        public ProcessingResult process(Object pi, Collection<Path> po, boolean endOfContract) throws Exception {
            Path dir = null;
            if (pi instanceof Path) {
                dir = (Path)pi;
            } else if (pi instanceof String) {
                dir = Paths.get((String)pi, new String[0]);
            } else {
                throw new UnexpectedPayloadException("Path scanner expect a Path or a String as input. Found: " + pi.getClass());
            }
            this.scanner.clear();
            for (String pattern : PathScanner.this.patterns) {
                PathMatcher pm = dir.getFileSystem().getPathMatcher(pattern);
                this.scanner.addMatcher(pm);
            }
            Files.walkFileTree(dir, Collections.EMPTY_SET, PathScanner.this.maxDepth, this.scanner);
            po.addAll(this.scanner.getMatchingPaths());
            return ProcessingResult.BOTH_COMPLETE;
        }
    }
}

