/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.io.working;

import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelWriter;

public class WorkingFileChannelWriter
extends AsynchronousFileChannelWriter {
    public static final Set<StandardOpenOption> DELETE_ON_CLOSE = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE));
    public Set<StandardOpenOption> deleteOptions = DELETE_ON_CLOSE;

    public WorkingFileChannelWriter() {
        this.closeChannels = false;
    }

    @Override
    protected AsynchronousFileChannelWriter.FileChannelContext newContext() {
        return new WorkingFileChannelContext();
    }

    public class WorkingFileChannelContext
    extends AsynchronousFileChannelWriter.FileChannelContext {
        protected boolean deleteOnExit;

        @Override
        protected void initialize() throws Exception {
            Object obj = this.getContract().get("IOProperties.DELETE_WORKING_FILES");
            this.deleteOnExit = null == obj ? true : (obj instanceof Boolean ? (Boolean)obj : Boolean.parseBoolean(obj.toString()));
            super.initialize();
        }

        @Override
        protected AsynchronousFileChannel openChannel(Path p) throws IOException {
            if (this.deleteOnExit) {
                return AsynchronousFileChannel.open(p, WorkingFileChannelWriter.this.deleteOptions, WorkingFileChannelWriter.this.getExecutorService(), new FileAttribute[0]);
            }
            return super.openChannel(p);
        }
    }
}

