/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.metadata;

import java.util.Collection;
import java.util.Deque;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;

public class PropertyReporter
extends BasicProcessor {
    protected String key = null;
    protected String label = null;
    protected boolean isRequired = false;

    public PropertyReporter setKey(String k) {
        this.key = k;
        return this;
    }

    @Override
    public PropertyReporter setLabel(String l) {
        this.label = l;
        return this;
    }

    public PropertyReporter setIsRequired(boolean b) {
        this.isRequired = b;
        return this;
    }

    @Override
    public void consume(Contract c, Bucket bin, boolean endOfInput) {
        Object o = c.get(this.key);
        if (null != o) {
            this.logger.info(this.toString(c, o));
        } else {
            this.logEmpty();
        }
        this.p.consume(c, bin, endOfInput);
    }

    protected String toString(Contract c, Object value) {
        Formatter f = new Formatter();
        this.toFormatter(f, c, value);
        return f.toString();
    }

    protected void toFormatter(Formatter f, Contract c, Object value) {
        if (null == this.label) {
            f.format("Loaded '%s' with value: %s", this.key, value);
        } else {
            f.format("Loaded '%s' with value: %s", this.label, value);
        }
    }

    protected void logEmpty() {
        Formatter f = new Formatter();
        if (this.isRequired) {
            f.format("Did not find a value for required property as expected. Label: %s", this.label);
            this.logger.info(f.toString());
        } else if (this.logger.isDebugEnabled()) {
            f.format("Did not find a value for property. Label: %s", this.label);
            this.logger.debug(f.toString());
        }
    }

    public static class MapRprtr
    extends PropertyReporter {
        @Override
        protected void toFormatter(Formatter f, Contract c, Object value) {
            Map map = (Map)value;
            f.format("Loaded '%s', a Map of size %d", this.label, map.size());
        }
    }

    public static class CollectionRprtr
    extends PropertyReporter {
        @Override
        protected void toFormatter(Formatter f, Contract c, Object value) {
            Collection col = (Collection)value;
            String clsLbl = this.getClassLabel(col);
            f.format("Loaded '%s', a %s of size %d", this.label, clsLbl, col.size());
        }

        public String getClassLabel(Object colVal) {
            if (colVal instanceof Deque) {
                return "Deque";
            }
            if (colVal instanceof Queue) {
                return "Queue";
            }
            if (colVal instanceof List) {
                return "List";
            }
            if (colVal instanceof Set) {
                return "Set";
            }
            return "Collection";
        }
    }
}

