/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser;

public class CharArraySequence
implements CharSequence {
    char[] str;
    int from;
    int to;

    public CharArraySequence() {
        this.clear();
    }

    public CharArraySequence(char[] c) {
        this.str = c;
        this.from = 0;
        this.to = c.length;
    }

    public CharArraySequence(char[] c, int f, int t) {
        this.init(c, f, t);
    }

    @Override
    public final int length() {
        return this.to - this.from;
    }

    @Override
    public final char charAt(int index) {
        return this.str[this.from + index];
    }

    @Override
    public CharArraySequence subSequence(int start, int end) {
        return new CharArraySequence(this.str, this.from + start, this.from + end);
    }

    @Override
    public String toString() {
        if (null == this.str) {
            return null;
        }
        return new String(this.str, this.from, this.length());
    }

    public char[] toCharArray() {
        if (null == this.str) {
            return null;
        }
        char[] chars = new char[this.length()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.str[this.from + i];
        }
        return chars;
    }

    public byte[] toByteArray() {
        if (null == this.str) {
            return null;
        }
        byte[] chars = new byte[this.length()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (byte)this.str[this.from + i];
        }
        return chars;
    }

    public void toStringBuilder(StringBuilder sb) {
        if (null != this.str) {
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                sb.append(this.str[this.from + i]);
            }
        }
    }

    public final boolean equalsCharSeq(CharSequence cs) {
        if (this.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWith(CharSequence prefix) {
        if (this.length() < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (this.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public final void init(char[] c, int f, int t) {
        this.str = c;
        this.from = f;
        this.to = t;
    }

    public int getStartIndex() {
        return this.from;
    }

    public int getEndIndex() {
        return this.to;
    }

    public char[] getArray() {
        return this.str;
    }

    public final void clear() {
        this.str = null;
        this.from = 0;
        this.to = 0;
    }
}

