/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser;

import java.nio.CharBuffer;

public abstract class CharBufferState {
    private int bufferCount = 0;
    private long charCount = 0L;
    private CharBuffer currentBuffer = null;
    private boolean endOfStream = false;
    private char[] charArray = null;
    private int start = 0;
    private int stop = 0;
    private int position = 0;
    private int chunkStart = 0;

    public void clear() {
        this.bufferCount = 0;
        this.charCount = 0L;
        this.currentBuffer = null;
        this.endOfStream = false;
        this.charArray = null;
        this.start = 0;
        this.stop = 0;
        this.position = 0;
        this.chunkStart = 0;
    }

    protected final boolean isCurrentBuffer() {
        return null != this.currentBuffer;
    }

    public void setup(CharBuffer cb, boolean eos) {
        ++this.bufferCount;
        this.currentBuffer = cb;
        this.endOfStream = eos;
        this.charArray = cb.array();
        this.start = cb.arrayOffset();
        this.stop = this.start + cb.remaining();
        this.position = this.start;
        this.chunkStart = this.start;
    }

    public void tearDown() {
        this.charCount += (long)this.size();
        this.currentBuffer = null;
        this.endOfStream = false;
        this.charArray = null;
        this.start = 0;
        this.stop = 0;
        this.position = 0;
        this.chunkStart = 0;
    }

    protected final int bufferCount() {
        return this.bufferCount();
    }

    protected final char[] charArray() {
        return this.charArray;
    }

    protected final boolean isEndOfStream() {
        return this.endOfStream;
    }

    protected final int size() {
        return this.stop - this.start;
    }

    protected final int position() {
        return this.position;
    }

    protected final char currentChar() {
        return this.charArray[this.position];
    }

    protected final void nextPosition() {
        ++this.position;
    }

    protected final int stop() {
        return this.stop;
    }

    protected final boolean hasRemaining() {
        return this.position < this.stop;
    }

    protected final int chunkStart() {
        return this.chunkStart;
    }

    protected final boolean hasCaptured() {
        return this.chunkStart < this.position;
    }

    protected final void setChunkStart() {
        this.chunkStart = this.position + 1;
    }

    protected final long globalOffset() {
        return this.charCount - (long)this.start;
    }

    protected final long globalPosition() {
        return this.globalOffset() + (long)this.position + 1L;
    }
}

