/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser;

import java.nio.CharBuffer;
import java.util.LinkedList;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;

public class CharSequenceRegulator {
    protected LinkedList<CharSequence> queue = new LinkedList();
    protected SequenceWriter writer = new SequenceWriter();

    public final void clear() {
        this.queue.clear();
        this.writer.clear();
    }

    public final boolean hasRemaining() {
        return !this.queue.isEmpty() || this.writer.hasRemaining();
    }

    public final void append(CharArraySequence cas) {
        this.queue.add(cas);
    }

    public final void append(String st) {
        this.queue.add(st);
    }

    public final void append(CharSequence cs) {
        this.queue.add(cs);
    }

    public final boolean flush(CharBuffer cb) {
        if (this.writer.hasRemaining()) {
            this.writer.write(cb);
            if (this.writer.hasRemaining()) {
                return false;
            }
        }
        while (!this.queue.isEmpty()) {
            this.writer.init(this.queue.remove());
            this.writer.write(cb);
            if (!this.writer.hasRemaining()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Writer: '" + this.writer + "', Queue:" + this.queue;
    }

    public class SequenceWriter {
        CharSequence seq = null;
        int seqLength = 0;
        int start = 0;

        public void clear() {
            this.seq = null;
            this.seqLength = 0;
            this.start = 0;
        }

        public final void init(CharSequence cas) {
            this.seq = cas;
            this.seqLength = cas.length();
            this.start = 0;
        }

        public final boolean hasRemaining() {
            if (null == this.seq) {
                return false;
            }
            if (this.start < this.seqLength) {
                return true;
            }
            this.clear();
            return false;
        }

        final void write(CharBuffer cbuf) {
            int rem = cbuf.remaining();
            if (0 == rem) {
                return;
            }
            int length = this.seqLength - this.start;
            if (rem < length) {
                length = rem;
            }
            this.write(cbuf, this.start, length);
            this.start += length;
        }

        final void write(CharBuffer cbuf, int begin, int length) {
            if (this.seq instanceof CharArraySequence) {
                CharArraySequence cas = (CharArraySequence)this.seq;
                cbuf.put(cas.getArray(), cas.getStartIndex() + begin, length);
            } else if (this.seq instanceof String) {
                String str = (String)this.seq;
                cbuf.put(str, begin, begin + length);
            } else {
                int end = begin + length;
                while (begin < end) {
                    cbuf.put(this.seq.charAt(begin));
                    ++begin;
                }
            }
        }

        public String toString() {
            if (null == this.seq) {
                return "SequenceNulled";
            }
            String str = this.seq.toString();
            if (null == str) {
                return "SequenceArrayNulled";
            }
            return str.substring(this.start);
        }
    }
}

