/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.io.SubContractor;
import uk.ac.ox.well.t2d.async.processors.PayloadMulticaster;

public class ListMulticaster
implements Processor<List> {
    public Map<String, Context> cxtMap = new LinkedHashMap<String, Context>();
    protected Map<SubContractor, Processor<List>> processorMap = new LinkedHashMap<SubContractor, Processor<List>>();

    public void addProcessor(Processor<List> p, SubContractor sc) {
        this.processorMap.put(sc, p);
    }

    public Set<Processor> getProcessors() {
        HashSet<Processor> hs = new HashSet<Processor>();
        for (Processor<List> proc : this.processorMap.values()) {
            hs.add(proc);
        }
        return hs;
    }

    @Override
    public void commence() {
        for (Processor<List> p : this.processorMap.values()) {
            p.commence();
        }
    }

    @Override
    public void close() {
        for (Processor<List> p : this.processorMap.values()) {
            p.close();
        }
        this.cxtMap.clear();
        this.processorMap.clear();
    }

    @Override
    public void consume(Contract c, Bucket<List> bin, boolean endOfStream) {
        Context cxt = this.getContext(c);
        cxt.multiplex(bin, endOfStream);
        if (endOfStream) {
            this.removeContext(c);
        }
    }

    protected synchronized Context getContext(Contract parent) {
        Context cxt = this.cxtMap.get(parent.getId());
        if (null == cxt) {
            cxt = this.newContext(parent);
            this.cxtMap.put(parent.getId(), cxt);
        }
        return cxt;
    }

    protected Context newContext(Contract parent) {
        Context cxt = new Context();
        ContractGroup grp = new ContractGroup(parent);
        Iterator<Map.Entry<SubContractor, Processor<List>>> it = this.processorMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SubContractor, Processor<List>> entry = it.next();
            boolean finalize = !it.hasNext();
            ContractGroup.SiblingContract sub = grp.newContract(finalize);
            entry.getKey().setup(sub);
            cxt.addSubContract(sub, entry.getValue());
        }
        return cxt;
    }

    protected synchronized void removeContext(Contract parent) {
        this.cxtMap.remove(parent.getId());
    }

    public class ListBucketMultiplexer
    extends PayloadMulticaster<List> {
        public ListBucketMultiplexer(Bucket<List> bb, int size) {
            super(bb, size);
        }

        @Override
        protected List multiplexPayload(List p, int i) {
            return Collections.unmodifiableList(p);
        }
    }

    protected class Context {
        Map<Contract, Processor<List>> map = new LinkedHashMap<Contract, Processor<List>>();

        public void addSubContract(Contract sc, Processor<List> p) {
            this.map.put(sc, p);
        }

        public void multiplex(Bucket<List> bin, boolean endOfStream) {
            ListBucketMultiplexer bbbm = new ListBucketMultiplexer(bin, this.map.size());
            Iterator cit = bbbm.iterator();
            for (Map.Entry<Contract, Processor<List>> entry : this.map.entrySet()) {
                Bucket bkt = cit.next();
                entry.getValue().consume(entry.getKey(), bkt, endOfStream);
            }
        }
    }
}

