/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser;

import java.nio.CharBuffer;
import java.util.List;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.io.BufferConfigurable;
import uk.ac.ox.well.t2d.async.io.CharBufferFactory;
import uk.ac.ox.well.t2d.async.parser.CharSequenceRegulator;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class ListWriter<PI>
extends AbstractConveyor<ListWriterContext<PI>, List<PI>, CharBuffer>
implements BufferConfigurable {
    protected String separator = "\n";

    public ListWriter() {
        this.setPayloadManager(new CharBufferFactory());
    }

    @Override
    protected ListWriterContext newContext() {
        ListWriterContext cxt = new ListWriterContext();
        cxt.setSeparator(this.separator);
        return cxt;
    }

    public CharBufferFactory getPayloadFactory() {
        return (CharBufferFactory)this.payloadManager;
    }

    @Override
    public void setBufferCapacity(int bufferCapacity) {
        this.getPayloadFactory().setCapacity(bufferCapacity);
    }

    public static class ListWriterContext<PI>
    extends ProcessingContext<List<PI>, CharBuffer> {
        String separator;
        CharSequenceRegulator reg = new CharSequenceRegulator();
        List currentList;
        int currentIndex;

        public void setSeparator(String sep) {
            this.separator = sep;
        }

        @Override
        public void clear() {
            super.clear();
            this.resetBuffers();
        }

        public void resetBuffers() {
            this.reg.clear();
            this.currentList = null;
            this.currentIndex = 0;
        }

        protected String toString(Object o) {
            return o.toString();
        }

        @Override
        public ProcessingResult process(List pi, CharBuffer po, boolean endOfContract) {
            boolean poFini;
            if (null == this.currentList) {
                this.currentList = pi;
                this.currentIndex = 0;
            }
            if (this.reg.hasRemaining() && !this.reg.flush(po)) {
                return ProcessingResult.OUTPUT_COMPLETE;
            }
            while (this.currentIndex < this.currentList.size()) {
                Object o = this.currentList.get(this.currentIndex);
                String str = this.toString(o);
                ++this.currentIndex;
                this.reg.append(str);
                this.reg.append(this.separator);
                if (this.reg.flush(po)) continue;
                break;
            }
            boolean piFini = this.currentIndex >= this.currentList.size();
            boolean bl = poFini = !po.hasRemaining();
            if (piFini && poFini && !this.reg.hasRemaining()) {
                this.resetBuffers();
                po.flip();
                return ProcessingResult.BOTH_COMPLETE;
            }
            if (piFini && poFini && this.reg.hasRemaining()) {
                po.flip();
                return ProcessingResult.OUTPUT_COMPLETE;
            }
            if (piFini && endOfContract) {
                this.resetBuffers();
                po.flip();
                return ProcessingResult.BOTH_COMPLETE;
            }
            if (!piFini && poFini) {
                po.flip();
                return ProcessingResult.OUTPUT_COMPLETE;
            }
            if (piFini && !poFini) {
                this.resetBuffers();
                return ProcessingResult.INPUT_COMPLETE;
            }
            this.getContract().getLogger().warn("UNEXPECTED STATE: PI && PO have remaining");
            return ProcessingResult.FAILURE;
        }
    }
}

