/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ox.well.t2d.async.contracts.CollectionFactory;
import uk.ac.ox.well.t2d.async.metadata.MdataLdrBlock;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CsvParsingLogic;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.ped.WhiteSpaceParsingLogic;

public class StringArrayParser
extends TableParser {
    protected Map<Long, Integer> columns = new HashMap<Long, Integer>();

    public StringArrayParser() {
        this.columns.put(1L, 0);
        this.columns.put(2L, 1);
    }

    public StringArrayParser setColumns(long ... colNos) {
        this.columns.clear();
        if (0 == colNos.length) {
            throw new IllegalArgumentException();
        }
        int idx = 0;
        for (long l : colNos) {
            this.columns.put(new Long(l), idx);
            ++idx;
        }
        return this;
    }

    protected TableParsingLogic newLogic() {
        return new WhiteSpaceParsingLogic();
    }

    protected TableCellHandler newHandler() {
        return new Handler();
    }

    public static class CommaCsvStringArrayParser
    extends StringArrayParser {
        public CommaCsvStringArrayParser() {
            this.setPayloadManager(new CollectionFactory.ListFactory().setReuse(false));
        }

        @Override
        protected TableParsingLogic newLogic() {
            return new CsvParsingLogic().setCellSeparator(',');
        }
    }

    public static class MdataListLdrBlock
    extends MdataLdrBlock {
        public MdataListLdrBlock() {
            StringArrayParser sap = new StringArrayParser();
            sap.setPayloadManager(new CollectionFactory.ListFactory().setReuse(false));
            this.setParser(sap);
        }

        StringArrayParser getParser() {
            return (StringArrayParser)this.tableParsr;
        }
    }

    public class Handler
    extends TableCellHandlerBase {
        protected String[] thisArray = null;

        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Object po) throws Exception {
            Integer colIdx;
            if (null == this.thisArray) {
                this.thisArray = new String[StringArrayParser.this.columns.size()];
            }
            if (null != (colIdx = StringArrayParser.this.columns.get(meta.getColumnNumber()))) {
                this.thisArray[colIdx.intValue()] = cellData.toString();
            }
            if (meta.isEndOfLine()) {
                this.handleEndOfLine(po);
            }
            return false;
        }

        protected void handleEndOfLine(Object po) {
            Collection col = (Collection)po;
            col.add(this.thisArray);
            this.thisArray = null;
        }

        @Override
        public void clear() {
            this.thisArray = null;
        }
    }
}

