/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.CharBufferState;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;

public abstract class TableParsingBase<PO>
extends CharBufferState {
    public static final char CR_CHAR = '\r';
    public static final char LF_CHAR = '\n';
    private long lineCount = 0L;
    private long cellCount = 0L;
    private long columnCount = 0L;
    private boolean crFlag = false;
    private List<char[]> remainders = new ArrayList<char[]>();
    private TableCellMetadataImpl meta;
    private CharArraySequence charSequence = new CharArraySequence();
    private TableCellHandler<PO> handler = null;

    public TableParsingBase() {
        this.meta = new TableCellMetadataImpl();
    }

    public TableCellHandler<PO> getHandler() {
        return this.handler;
    }

    public void setHandler(TableCellHandler<PO> tch) {
        this.handler = tch;
    }

    @Override
    public void clear() {
        super.clear();
        this.lineCount = 0L;
        this.cellCount = 0L;
        this.columnCount = 0L;
        this.crFlag = false;
        this.remainders.clear();
        this.meta.clear();
        this.charSequence.clear();
        this.handler.clear();
    }

    protected final boolean isCrFlag() {
        return this.crFlag;
    }

    protected final void setCrFlag() {
        this.crFlag = '\r' == this.currentChar();
    }

    protected final long lineNumber() {
        return this.lineCount + 1L;
    }

    protected final long columnCount() {
        return this.columnCount;
    }

    protected final void newLine() {
        ++this.lineCount;
        this.columnCount = 0L;
    }

    protected final void newCell() {
        ++this.cellCount;
        ++this.columnCount;
    }

    public final boolean markCell(Bucket<PO> bo) throws Exception {
        return this.handleCell(false, bo);
    }

    public final boolean markLine(Bucket<PO> bo) throws Exception {
        boolean isPayloadFull = this.handleCell(true, bo);
        this.newLine();
        return isPayloadFull;
    }

    public final boolean handleCell(boolean eol, Bucket<PO> bo) throws Exception {
        this.newCell();
        if (this.isRemainder()) {
            String str = this.concatRemainder();
            this.charSequence.init(str.toString().toCharArray(), 0, str.length());
        } else {
            this.charSequence.init(this.charArray(), this.chunkStart(), this.position());
        }
        boolean isPayloadFull = this.handleCellData(this.charSequence, eol, bo);
        this.setChunkStart();
        return isPayloadFull;
    }

    protected final boolean handleCellData(CharArraySequence cs, boolean eol, Bucket<PO> bo) throws Exception {
        this.meta.charNumber = this.globalPosition() - (long)cs.length();
        this.meta.lineNumber = this.lineNumber();
        this.meta.columnNumber = this.columnCount();
        this.meta.eol = eol;
        return this.handler.cell(this.meta, cs, bo);
    }

    protected final boolean isRemainder() {
        return !this.remainders.isEmpty();
    }

    protected final void storeRemainder() {
        char[] ra = Arrays.copyOfRange(this.charArray(), this.chunkStart(), this.stop());
        this.remainders.add(ra);
    }

    protected final String concatRemainder() {
        StringBuilder sb = new StringBuilder();
        for (char[] chr : this.remainders) {
            sb.append(chr);
        }
        sb.append(this.charArray(), this.chunkStart(), this.position() - this.chunkStart());
        this.remainders.clear();
        return sb.toString();
    }

    public static char[] concat(char[] first, char[] second) {
        char[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static class TableCellMetadataImpl
    implements TableCellMetadata {
        long charNumber;
        long lineNumber;
        long columnNumber;
        boolean eol;

        @Override
        public long getCharNumber() {
            return this.charNumber;
        }

        @Override
        public long getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public long getColumnNumber() {
            return this.columnNumber;
        }

        @Override
        public boolean isEndOfLine() {
            return this.eol;
        }

        public void clear() {
            this.charNumber = 0L;
            this.lineNumber = 0L;
            this.columnNumber = 0L;
            this.eol = false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CharNumber=").append(this.charNumber);
            sb.append(", LineNumber=").append(this.lineNumber);
            sb.append(", ColumnNumber=").append(this.columnNumber);
            sb.append(" Eol=").append(this.eol);
            return sb.toString();
        }
    }
}

