/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser;

import java.nio.CharBuffer;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.parser.TableParsingBase;

public abstract class TableParsingLogic<PO>
extends TableParsingBase {
    protected boolean tableStarted = false;
    protected boolean scanCompleted = false;
    protected boolean finishCompleted = false;
    protected boolean tableEnded = false;

    protected abstract boolean isSeparatorChar(char var1);

    @Override
    public void clear() {
        super.clear();
        this.tableStarted = false;
        this.scanCompleted = false;
        this.finishCompleted = false;
        this.tableEnded = false;
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.scanCompleted = false;
        this.finishCompleted = false;
    }

    public final ProcessingResult process(CharBuffer cb, Bucket<PO> bo, boolean endOfStream) throws Exception {
        if (!this.isCurrentBuffer()) {
            this.setup(cb, endOfStream);
        }
        if (this.tryFlush(bo)) {
            return ProcessingResult.OUTPUT_COMPLETE;
        }
        if (this.tryStartTable(bo)) {
            return ProcessingResult.OUTPUT_COMPLETE;
        }
        if (this.tryScan(bo)) {
            return ProcessingResult.OUTPUT_COMPLETE;
        }
        if (this.tryFinish(bo)) {
            return ProcessingResult.OUTPUT_COMPLETE;
        }
        this.tearDown();
        if (endOfStream && this.tryEndTable(bo)) {
            return ProcessingResult.OUTPUT_COMPLETE;
        }
        if (endOfStream) {
            return ProcessingResult.BOTH_COMPLETE;
        }
        return ProcessingResult.INPUT_COMPLETE;
    }

    public final boolean tryFlush(Bucket<PO> bo) {
        return this.getHandler().flush(bo);
    }

    public final boolean tryStartTable(Bucket<PO> bo) throws Exception {
        if (!this.tableStarted) {
            this.tableStarted = true;
            return this.getHandler().startTable(bo);
        }
        return false;
    }

    public final boolean tryScan(Bucket<PO> bo) throws Exception {
        if (!this.scanCompleted) {
            if (this.scan(bo)) {
                return true;
            }
            this.scanCompleted = true;
        }
        return false;
    }

    public final boolean tryFinish(Bucket<PO> bo) throws Exception {
        if (!this.finishCompleted) {
            if (this.finish(bo)) {
                return true;
            }
            this.finishCompleted = true;
        }
        return false;
    }

    public final boolean tryEndTable(Bucket<PO> bo) throws Exception {
        if (!this.tableEnded) {
            if (this.getHandler().endTable(bo)) {
                return true;
            }
            this.tableEnded = true;
        }
        return false;
    }

    public final boolean scan(Bucket<PO> bo) throws Exception {
        char currentChar = '\u0000';
        boolean isPayloadFull = false;
        while (this.hasRemaining()) {
            currentChar = this.currentChar();
            isPayloadFull = this.handleChar(currentChar, bo);
            this.setCrFlag();
            this.nextPosition();
            if (!isPayloadFull) continue;
            break;
        }
        return isPayloadFull;
    }

    protected final boolean finish(Bucket<PO> bo) throws Exception {
        if (this.hasCaptured()) {
            if (this.isEndOfStream()) {
                return this.markLine(bo);
            }
            this.storeRemainder();
            return false;
        }
        if (this.isEndOfStream() && this.isRemainder()) {
            return this.markLine(bo);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean handleChar(char currentChar, Bucket<PO> bo) throws Exception {
        if ('\r' == currentChar) {
            return this.markLine(bo);
        }
        if ('\n' == currentChar) {
            if (!this.isCrFlag()) return this.markLine(bo);
            this.setChunkStart();
            return false;
        } else {
            if (!this.isSeparatorChar(currentChar)) return false;
            return this.markCell(bo);
        }
    }
}

