/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser.csv;

public class CsvScanner {
    public static final char NUL = '\u0000';
    public static final char CR = '\r';
    public static final char LF = '\n';
    private char delimiter;
    private char qualifier;
    private char previousChar;
    private char currentChar;
    private boolean withinQuote;

    public CsvScanner() {
        this.delimiter = '\u0000';
        this.qualifier = '\u0000';
        this.withinQuote = false;
    }

    public CsvScanner(char dltr, char qual) {
        if ('\u0000' == dltr || qual == dltr) {
            throw new RuntimeException("Delimiter or Qualifier cannot be NUL");
        }
        this.delimiter = dltr;
        this.qualifier = qual;
        this.withinQuote = false;
    }

    public void clear() {
        this.clearChars();
        this.withinQuote = false;
    }

    protected void clearChars() {
        this.previousChar = '\u0000';
        this.currentChar = '\u0000';
    }

    public Result handleCharacter(char c) {
        this.previousChar = this.currentChar;
        this.currentChar = c;
        if (this.withinQuote) {
            return this.handleQuoted();
        }
        return this.handleNormal();
    }

    protected Result handleNormal() {
        if ('\u0000' != this.qualifier && '\u0000' != this.delimiter && (this.previousChar == this.delimiter || this.previousChar == '\u0000') && this.currentChar == this.qualifier) {
            this.withinQuote = true;
            this.clearChars();
            return Result.Nothing;
        }
        if ('\n' == this.currentChar && '\r' == this.previousChar) {
            return Result.Nothing;
        }
        if ('\r' == this.currentChar || '\n' == this.currentChar) {
            return Result.EndOfLine;
        }
        if ('\u0000' != this.delimiter && this.currentChar == this.delimiter) {
            return Result.EndOfField;
        }
        return Result.Content;
    }

    protected Result handleQuoted() {
        if (this.currentChar == this.qualifier && this.previousChar == this.qualifier) {
            this.clearChars();
            return Result.Content;
        }
        if (this.currentChar == this.delimiter && this.previousChar == this.qualifier) {
            this.withinQuote = false;
            return Result.qEndOfField;
        }
        if ((this.currentChar == '\r' || this.currentChar == '\n') && this.previousChar == this.qualifier) {
            this.withinQuote = false;
            return Result.qEndOfLine;
        }
        if (this.currentChar == this.qualifier) {
            return Result.Nothing;
        }
        if (this.previousChar == this.qualifier) {
            return Result.Content;
        }
        return Result.Content;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        if ('\u0000' == delimiter) {
            throw new RuntimeException("Delimiter cannot be NUL");
        }
        this.delimiter = delimiter;
    }

    public char getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(char qualifier) {
        if ('\u0000' == qualifier) {
            throw new RuntimeException("Qualifier cannot be NUL");
        }
        this.qualifier = qualifier;
    }

    public static enum Result {
        Content,
        EndOfField,
        EndOfLine,
        qEndOfField,
        qEndOfLine,
        Nothing;

    }
}

