/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser.csv;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ox.well.t2d.async.parser.csv.ChunkSubsequence;
import uk.ac.ox.well.t2d.async.parser.csv.SplitterChunker;

public class LineEndingChunker
implements SplitterChunker {
    protected int linesPerChunk = 1000;
    protected int currentChunk = 0;
    protected int recordOffset = 0;
    protected int currentLine = 0;
    protected long totalLineCount = 1L;
    protected long totalCharCount = 0L;
    protected char previousChar = '\u0000';
    protected List<ChunkSubsequence> subsequences = new ArrayList<ChunkSubsequence>();

    @Override
    public void initialize() {
        this.currentChunk = 0;
        this.currentLine = 0;
        this.recordOffset = 0;
        this.totalLineCount = 1L;
        this.totalCharCount = 0L;
        this.previousChar = '\u0000';
        this.subsequences.clear();
    }

    public void setLinesPerChunk(int max) {
        if (0 >= max) {
            throw new IllegalArgumentException("Lines per chunk is 0 or less. Found: " + max);
        }
        this.linesPerChunk = max;
    }

    @Override
    public long getTotalRecordCount() {
        return this.totalLineCount;
    }

    @Override
    public long getTotalCharCount() {
        return this.totalCharCount;
    }

    @Override
    public List<ChunkSubsequence> scan(CharBuffer cbuf, boolean endOfStream) {
        char[] ca = cbuf.array();
        int pos = cbuf.position();
        int offset = cbuf.arrayOffset() + pos;
        return this.scan(ca, offset, cbuf.remaining(), endOfStream);
    }

    public List<ChunkSubsequence> scan(String str, boolean endOfStream) {
        return this.scan(str.toCharArray(), 0, str.length(), endOfStream);
    }

    public List<ChunkSubsequence> scan(char[] ca, int off, int len, boolean endOfStream) {
        this.subsequences.clear();
        int start = off;
        int end = off + len;
        int chunkStart = start;
        int endOfLine = start;
        for (int i = start; i < end; ++i) {
            switch (ca[i]) {
                case '\r': {
                    if ('\r' != this.previousChar) break;
                    endOfLine = i;
                    ++this.currentLine;
                    ++this.totalLineCount;
                    break;
                }
                case '\n': {
                    endOfLine = i + 1;
                    ++this.currentLine;
                    ++this.totalLineCount;
                    break;
                }
                default: {
                    if ('\r' != this.previousChar) break;
                    endOfLine = i;
                    ++this.currentLine;
                    ++this.totalLineCount;
                }
            }
            this.previousChar = ca[i];
            if (this.linesPerChunk > this.currentLine) continue;
            ChunkSubsequence cas = new ChunkSubsequence(this.currentChunk, this.recordOffset, true, ca, chunkStart, endOfLine - chunkStart);
            this.subsequences.add(cas);
            chunkStart = endOfLine;
            ++this.currentChunk;
            this.recordOffset += this.currentLine;
            this.currentLine = 0;
        }
        this.totalCharCount += (long)len;
        if (end > chunkStart) {
            ChunkSubsequence cas = new ChunkSubsequence(this.currentChunk, this.recordOffset, endOfStream, ca, chunkStart, end - chunkStart);
            this.subsequences.add(cas);
        }
        if (endOfStream && 0L < this.totalCharCount && ('\r' == this.previousChar || '\n' == this.previousChar)) {
            --this.totalLineCount;
        }
        if (endOfStream && 0L >= this.totalCharCount) {
            --this.totalLineCount;
        }
        if (endOfStream && 0L < this.totalCharCount && len <= 0) {
            ChunkSubsequence cas = new ChunkSubsequence(this.currentChunk, this.recordOffset, endOfStream, ca, off, len);
            this.subsequences.add(cas);
        }
        return this.subsequences;
    }
}

