/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser.csv;

import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.parser.csv.ChunkSubsequence;
import uk.ac.ox.well.t2d.async.parser.csv.SplitterChunker;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;
import uk.ac.ox.well.t2d.async.processors.BucketMulticaster;
import uk.ac.ox.well.t2d.async.processors.NullPayloadManager;

public abstract class Splitter
extends AbstractConveyor<Context, CharBuffer, CharBuffer> {
    public static final String CHUNK_INDEX_KEY = "Splitter.ChunkIndex";
    public static final String RECORD_OFFSET_KEY = "Splitter.RecordOffset";
    public static final String RECORD_COUNT_KEY = "Splitter.RecordCount";
    public static final String CHAR_COUNT_KEY = "Splitter.CharCount";

    public Splitter() {
        this.setPayloadManager(new NullPayloadManager());
    }

    @Override
    protected Context newContext() {
        return new Context(this.newChunker());
    }

    protected abstract SplitterChunker newChunker();

    protected Processor getProcessor() {
        return this.processor;
    }

    @Override
    protected void processingCompleted(ProcessingResult result, Context context) {
        context.setPayloadOut(null);
        this.commandComplete(context.getCommand());
        if (context.isEndOfContract()) {
            this.removeContext(context.getContract());
        }
        this.prompt();
    }

    public class CharBufferMulticaster
    extends BucketMulticaster<CharBuffer, CharBuffer> {
        Bucket<CharBuffer> dummyBucket;

        public CharBufferMulticaster(Context cxt) {
            super(cxt.getPayloadIn());
            this.dummyBucket = cxt.getPayloadOut();
        }

        @Override
        protected void recycleParent() {
            super.recycleParent();
            this.dummyBucket.recycle();
        }

        public Bucket<CharBuffer> newChildBucket(char[] carray, int offset, int length) {
            CharBuffer cbuf = CharBuffer.wrap(carray, offset, length);
            BucketMulticaster.ChildBucket cb = new BucketMulticaster.ChildBucket(this, cbuf);
            this.children.add(cb);
            if (offset + length >= carray.length) {
                this.isFinalized = true;
            }
            return cb;
        }

        public Bucket<CharBuffer> newChildBucket(ChunkSubsequence cs) {
            return this.newChildBucket(cs.getCharArray(), cs.getOffset(), cs.getLength());
        }
    }

    public class Context
    extends ProcessingContext<CharBuffer, CharBuffer> {
        SplitterChunker chnkr;
        ContractGroup contractGroup;
        Map<Integer, Contract> contractMap;

        public Context(SplitterChunker sc) {
            this.chnkr = sc;
        }

        @Override
        protected void initialize() {
            this.contractGroup = new ContractGroup(this.getContract());
            this.contractMap = new HashMap<Integer, Contract>();
            this.chnkr.initialize();
        }

        @Override
        public void clear() {
            this.contractMap.clear();
            this.contractMap = null;
            this.contractGroup = null;
            this.chnkr.initialize();
        }

        @Override
        public ProcessingResult process() {
            CharBufferMulticaster mcaster = new CharBufferMulticaster(this);
            List<ChunkSubsequence> chunks = this.chnkr.scan((CharBuffer)this.getPayloadIn().getPayload(), this.isEndOfContract());
            for (int i = 0; i < chunks.size(); ++i) {
                boolean isLastInList = i + 1 >= chunks.size();
                ChunkSubsequence chunk = chunks.get(i);
                Contract sc = this.getSubcontract(chunk);
                Bucket<CharBuffer> bckt = mcaster.newChildBucket(chunk);
                if (this.isEndOfContract() && isLastInList) {
                    this.contractGroup.setFinalize();
                }
                Splitter.this.getProcessor().consume(sc, bckt, chunk.isEndOfChunk());
            }
            if (this.isEndOfContract()) {
                this.getContract().put(Splitter.RECORD_COUNT_KEY, this.chnkr.getTotalRecordCount());
                this.getContract().put(Splitter.CHAR_COUNT_KEY, this.chnkr.getTotalCharCount());
            }
            return ProcessingResult.BOTH_COMPLETE;
        }

        public Contract getSubcontract(ChunkSubsequence chunk) {
            Contract c = this.contractMap.get(chunk.getChunkIndex());
            if (null == c) {
                c = this.contractGroup.newContract(false);
                c.put(Splitter.CHUNK_INDEX_KEY, chunk.getChunkIndex());
                c.put(Splitter.RECORD_OFFSET_KEY, chunk.getRecordOffset());
                this.contractMap.put(chunk.getChunkIndex(), c);
            }
            return c;
        }
    }
}

