/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser.proto;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;

public abstract class TableParsingLogic<PO> {
    public static final char CR_CHAR = '\r';
    public static final char LF_CHAR = '\n';
    protected TableCellHandler<PO> handler = null;
    protected TableCellMetadataImpl meta;
    private int bufferCount = 0;
    private long charCount = 0L;
    private long lineCount = 0L;
    private long cellCount = 0L;
    private long columnCount = 0L;
    private boolean crStateFlag = false;
    private List<char[]> remainders = new ArrayList<char[]>();
    CharArraySequence charSequence = new CharArraySequence();

    public TableParsingLogic() {
        this.meta = new TableCellMetadataImpl();
        this.remainders.clear();
    }

    public void setHandler(TableCellHandler<PO> tch) {
        this.handler = tch;
    }

    public TableCellHandler<PO> getHandler() {
        return this.handler;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    public long getCellCount() {
        return this.cellCount;
    }

    protected abstract boolean isSeparatorChar(char var1);

    public void clear() {
        this.bufferCount = 0;
        this.charCount = 0L;
        this.lineCount = 0L;
        this.cellCount = 0L;
        this.columnCount = 0L;
        this.crStateFlag = false;
        this.remainders.clear();
        this.handler.clear();
    }

    public final void scan(CharBuffer cb, Bucket<PO> bo, boolean endOfInput) throws Exception {
        if (0 == this.bufferCount) {
            this.handler.startTable(bo);
        }
        ++this.bufferCount;
        char[] ca = cb.array();
        int start = cb.arrayOffset();
        int stop = start + cb.remaining();
        int size = cb.remaining();
        long globalOffset = this.charCount - (long)start;
        this.loop(globalOffset, ca, start, stop, endOfInput, bo);
        this.charCount += (long)size;
        if (endOfInput) {
            this.handler.endTable(bo);
        }
    }

    public final void loop(long globalOffset, char[] ca, int start, int stop, boolean endOfInput, Bucket<PO> bo) throws Exception {
        int cellStart = start;
        boolean cr = this.crStateFlag;
        boolean payloadFull = false;
        for (int i = start; i < stop; ++i) {
            if ('\n' == ca[i]) {
                if (!cr) {
                    payloadFull = this.markLine(globalOffset, ca, cellStart, i, bo);
                }
                cellStart = i + 1;
                cr = false;
                continue;
            }
            if ('\r' == ca[i]) {
                payloadFull = this.markLine(globalOffset, ca, cellStart, i, bo);
                cellStart = i + 1;
                cr = true;
                continue;
            }
            if (this.isSeparatorChar(ca[i])) {
                this.markCell(globalOffset, ca, cellStart, i, bo);
                cellStart = i + 1;
                cr = false;
                continue;
            }
            cr = false;
        }
        this.endOfBuffer(globalOffset, ca, cellStart, stop, endOfInput, bo);
        this.crStateFlag = cr;
    }

    protected final boolean endOfBuffer(long globalOffset, char[] ca, int cellStart, int stop, boolean endOfInput, Bucket<PO> bo) throws Exception {
        if (cellStart < stop) {
            if (endOfInput) {
                return this.markLine(globalOffset, ca, cellStart, stop, bo);
            }
            char[] ra = Arrays.copyOfRange(ca, cellStart, stop);
            this.remainders.add(ra);
            return false;
        }
        if (endOfInput && !this.remainders.isEmpty()) {
            return this.markLine(globalOffset, ca, cellStart, stop, bo);
        }
        return false;
    }

    public final boolean markLine(long globalOffset, char[] str, int from, int to, Bucket<PO> bo) throws Exception {
        boolean rv = this.markCell(globalOffset, str, from, to, bo);
        ++this.lineCount;
        this.columnCount = 0L;
        return rv;
    }

    public final boolean markCell(long globalOffset, char[] ca, int from, int to, Bucket<PO> bo) throws Exception {
        ++this.cellCount;
        ++this.columnCount;
        long position = globalOffset + (long)from;
        if (!this.remainders.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (char[] chr : this.remainders) {
                sb.append(chr);
            }
            sb.append(ca, from, to - from);
            String str = sb.toString();
            this.charSequence.init(str.toString().toCharArray(), 0, str.length());
            boolean rv = this.handleCellData(position -= (long)sb.length(), this.charSequence, bo);
            this.remainders.clear();
            this.charSequence.clear();
            return rv;
        }
        this.charSequence.init(ca, from, to);
        boolean rv = this.handleCellData(position, this.charSequence, bo);
        this.charSequence.clear();
        return rv;
    }

    protected final boolean handleCellData(long position, CharArraySequence cs, Bucket<PO> bo) throws Exception {
        this.meta.charNumber = position + 1L;
        this.meta.lineNumber = this.lineCount + 1L;
        this.meta.columnNumber = this.columnCount;
        return this.handler.cell(this.meta, cs, bo);
    }

    public static char[] concat(char[] first, char[] second) {
        char[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static class TableCellMetadataImpl
    implements TableCellMetadata {
        long charNumber;
        long lineNumber;
        long columnNumber;
        boolean eol;

        @Override
        public long getCharNumber() {
            return this.charNumber;
        }

        @Override
        public long getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public long getColumnNumber() {
            return this.columnNumber;
        }

        @Override
        public boolean isEndOfLine() {
            return this.eol;
        }
    }
}

