/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.parser.rig;

import java.nio.CharBuffer;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.gzip.GzipAwarePathFinder;
import uk.ac.ox.well.t2d.async.gzip.GzipDecoder;
import uk.ac.ox.well.t2d.async.gzip.GzipDecoderBypass;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelReader;
import uk.ac.ox.well.t2d.async.io.CharacterDecoder;
import uk.ac.ox.well.t2d.async.metadata.FileWrtrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.parser.CharArraySequence;
import uk.ac.ox.well.t2d.async.parser.TableCellHandler;
import uk.ac.ox.well.t2d.async.parser.TableCellHandlerBase;
import uk.ac.ox.well.t2d.async.parser.TableCellMetadata;
import uk.ac.ox.well.t2d.async.parser.TableParser;
import uk.ac.ox.well.t2d.async.parser.TableParsingLogic;
import uk.ac.ox.well.t2d.async.ped.WhiteSpaceParsingLogic;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class BareTableParserBenchmarkBlck
extends SubSection {
    public void compose() {
        this.addProcessor(new MetadataReader().setPropertyKey("IOProperties.IN_PATH").setIsRequired(true));
        this.addProcessor(new GzipAwarePathFinder());
        this.addProcessor(new GzipDecoderBypass.Sensor());
        this.addProcessor(new AsynchronousFileChannelReader());
        GzipDecoderBypass gzipBypass = new GzipDecoderBypass();
        this.addProcessor(gzipBypass);
        super.addProcessor(new GzipDecoder());
        CharacterDecoder dcdr = new CharacterDecoder();
        this.addProcessor(dcdr);
        gzipBypass.setBypassProcessor(dcdr);
        BareParser parser = new BareParser();
        this.addProcessor(parser);
        this.addProcessor(new FileWrtrBlock.CharWrtr());
    }

    @Override
    public void commence() {
        this.compose();
        super.commence();
    }

    public static class Rig
    extends ExecutionRig {
        @Override
        public PrimaryContract execute() throws Exception {
            return this.execute(new BareTableParserBenchmarkBlck());
        }
    }

    public class BareHandler
    extends TableCellHandlerBase {
        long cellCount;

        @Override
        public boolean startTable(Bucket bo) throws Exception {
            this.cellCount = 0L;
            return false;
        }

        @Override
        public boolean cell(TableCellMetadata meta, CharArraySequence cellData, Bucket bo) throws Exception {
            ++this.cellCount;
            return false;
        }

        @Override
        public boolean endTable(Bucket bo) throws Exception {
            CharBuffer cb = CharBuffer.wrap(Long.toString(this.cellCount) + "\n");
            bo.setPayload(cb);
            return false;
        }
    }

    public class BareParser
    extends TableParser {
        protected TableParsingLogic newLogic() {
            return new WhiteSpaceParsingLogic();
        }

        protected TableCellHandler newHandler() {
            return new BareHandler();
        }
    }
}

