/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.parser.CharSequenceRegulator;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedHandler;
import uk.ac.ox.well.t2d.async.ped.BedParsingContext;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;

public class BedHandlerContext
extends BedParsingContext<CharBuffer> {
    protected CharSequenceRegulator regulator = new CharSequenceRegulator();
    protected BedHandler<CharSequenceRegulator> handler;

    public void setHandler(BedHandler<CharSequenceRegulator> handler) {
        this.handler = handler;
    }

    @Override
    public ProcessingResult process(ByteBuffer pi, CharBuffer po, boolean endOfContract) throws Exception {
        if (this.regulator.hasRemaining() && this.regulator.flush(po)) {
            po.flip();
            return ProcessingResult.OUTPUT_COMPLETE;
        }
        while (pi.hasRemaining()) {
            this.handleByte(pi.get());
            if (!this.regulator.hasRemaining() || !this.regulator.flush(po)) continue;
            po.flip();
            return ProcessingResult.OUTPUT_COMPLETE;
        }
        if (endOfContract) {
            po.flip();
            return ProcessingResult.BOTH_COMPLETE;
        }
        return ProcessingResult.INPUT_COMPLETE;
    }

    @Override
    public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
        BimEntry bim = this.meta.getBimList().get(snpIndex);
        FamEntry fam = this.meta.getFamList().get(sampleIndex);
        this.handler.handleCall(fam, bim, call, this.regulator);
    }
}

