/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.util.List;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;

public class BedMetadata {
    protected BedConstants.Order order;
    protected List<BimEntry> bimList;
    protected List<FamEntry> famList;
    protected int minorByteSpan;

    public int calcByteSpan(int i) {
        int bs = i / 4;
        if (0 != i % 4) {
            ++bs;
        }
        return bs;
    }

    public int calcMaxMajorPerBuffer(int bufferSize, int minorLength) {
        int byteSpan = this.calcByteSpan(minorLength);
        return bufferSize / byteSpan;
    }

    public int calcMaxMajorPerBuffer(int bufferSize) {
        return bufferSize / this.minorByteSpan;
    }

    public int calcRequiredBufferSize() {
        return this.minorByteSpan * this.getMajorSize();
    }

    public int getMinorSize() {
        if (this.order == BedConstants.Order.SNP_MAJOR) {
            return this.getFamList().size();
        }
        return this.getBimList().size();
    }

    public int getMajorSize() {
        if (this.order == BedConstants.Order.IND_MAJOR) {
            return this.getFamList().size();
        }
        return this.getBimList().size();
    }

    public List<BimEntry> getBimList() {
        return this.bimList;
    }

    public void setBimList(List<BimEntry> bimList) {
        this.bimList = bimList;
    }

    public List<FamEntry> getFamList() {
        return this.famList;
    }

    public void setFamList(List<FamEntry> famList) {
        this.famList = famList;
    }

    public BedConstants.Order getOrder() {
        return this.order;
    }

    public void setOrder(BedConstants.Order o) {
        this.order = o;
        this.initialize();
    }

    public void initialize() {
        this.minorByteSpan = this.calcByteSpan(this.getMinorSize());
    }

    public int getByteIndex(int majorIndex, int minorIndex) {
        int snpIdx = majorIndex * this.minorByteSpan;
        int sampleIdx = minorIndex / 4;
        return snpIdx + sampleIdx;
    }

    public int getByteOffset(int minorIndex) {
        return minorIndex % 4;
    }

    public int getMajorIndex(int byteIndex) {
        int snpIdx = byteIndex / this.minorByteSpan;
        return snpIdx;
    }

    public int getMinorIndex(int byteIndex) {
        int indOff = byteIndex % this.minorByteSpan * 4;
        return indOff;
    }

    public int getMinorLength(int minorIndex) {
        int length = this.getMinorSize() - minorIndex;
        if (length > 4) {
            length = 4;
        }
        return length;
    }

    public BedConstants.Call getCall(int offset, byte b) {
        if (offset >= 4) {
            throw new RuntimeException();
        }
        int bitOffset = offset * 2;
        boolean b1 = this.isBitSet(bitOffset, b);
        boolean b2 = this.isBitSet(bitOffset + 1, b);
        if (!b1 && !b2) {
            return BedConstants.Call.HOM1;
        }
        if (!b1 && b2) {
            return BedConstants.Call.HET;
        }
        if (b1 && b2) {
            return BedConstants.Call.HOM2;
        }
        return BedConstants.Call.NC;
    }

    public byte setCall(BedConstants.Call call, int offset, byte b) {
        boolean b2;
        boolean b1;
        if (offset >= 4) {
            throw new RuntimeException();
        }
        switch (call) {
            case HOM1: {
                b1 = false;
                b2 = false;
                break;
            }
            case HET: {
                b1 = false;
                b2 = true;
                break;
            }
            case HOM2: {
                b1 = true;
                b2 = true;
                break;
            }
            case NC: {
                b1 = true;
                b2 = false;
                break;
            }
            default: {
                b1 = true;
                b2 = false;
            }
        }
        int bitOffset = offset * 2;
        byte rb = b;
        rb = this.setBit(b1, bitOffset, rb);
        rb = this.setBit(b2, bitOffset + 1, rb);
        return rb;
    }

    public final boolean isBitSet(int offset, byte b) {
        int bm = this.getBitmask(offset);
        return (b & bm) == bm;
    }

    public final byte setBit(boolean isSet, int offset, byte b) {
        int mask = this.getBitmask(offset);
        if (!isSet) {
            return (byte)((mask ^= 0xFFFFFFFF) & b);
        }
        return (byte)(mask | b);
    }

    public final int getBitmask(int offset) {
        int bm = 1;
        return bm << offset;
    }

    public BedConstants.Call flipHom(BedConstants.Call c) {
        if (BedConstants.Call.HOM1.equals((Object)c)) {
            return BedConstants.Call.HOM2;
        }
        if (BedConstants.Call.HOM2.equals((Object)c)) {
            return BedConstants.Call.HOM1;
        }
        return c;
    }
}

