/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.nio.ByteBuffer;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.metadata.RequiredPropertyValueNotFound;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BedMetadata;

public abstract class BedParsingContext<PO>
extends ProcessingContext<ByteBuffer, PO> {
    public static final String BED_METADATA_IN_KEY = "BedParsingContext.BedMetadataIn";
    protected BedMetadata meta;
    protected int index = 0;

    @Override
    protected void initialize() throws Exception {
        this.meta = (BedMetadata)this.getContract().get(BED_METADATA_IN_KEY);
        if (null == this.meta) {
            throw new RequiredPropertyValueNotFound(BED_METADATA_IN_KEY);
        }
    }

    public void handleByte(byte b) {
        if (this.index < 3) {
            this.handleHeader(b);
        } else {
            this.handleBody(this.index - 3, b);
        }
        ++this.index;
    }

    public void handleHeader(byte b) {
        if (this.index == 0 && b != 108) {
            throw new RuntimeException("Unexpected byte at index 0. Found: " + b);
        }
        if (this.index == 1 && b != 27) {
            throw new RuntimeException("Unexpected byte at index 1. Found: " + b);
        }
        if (this.index == 2) {
            if (b == 0) {
                this.meta.setOrder(BedConstants.Order.IND_MAJOR);
            } else if (b == 1) {
                this.meta.setOrder(BedConstants.Order.SNP_MAJOR);
            } else {
                throw new RuntimeException("Expected either SNP-major or Individual-Major. Found: " + b);
            }
        }
    }

    public void handleBody(int idx, byte b) {
        switch (this.meta.getOrder()) {
            case SNP_MAJOR: {
                this.handleBodySnpMajor(idx, b);
                break;
            }
            case IND_MAJOR: {
                this.handleBodyIndMajor(idx, b);
                break;
            }
        }
    }

    public void handleBodySnpMajor(int idx, byte b) {
        int snpIdx = this.meta.getMajorIndex(idx);
        int indIdx = this.meta.getMinorIndex(idx);
        int length = this.meta.getMinorLength(indIdx);
        this.handleSampleByte(snpIdx, indIdx, length, b);
    }

    public void handleSampleByte(int snpIndex, int indOffset, int length, byte b) {
        for (int i = 0; i < length; ++i) {
            int indIndex = indOffset + i;
            BedConstants.Call c = this.meta.getCall(i, b);
            this.handleCall(snpIndex, indIndex, c);
        }
    }

    public abstract void handleCall(int var1, int var2, BedConstants.Call var3);

    public void handleBodyIndMajor(int idx, byte b) {
        throw new RuntimeException("Individual Major not supported");
    }
}

