/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.util.Map;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.MapEntry;

public class BimEntry
extends MapEntry {
    protected String allele1;
    protected String allele2;

    public BimEntry() {
    }

    public BimEntry(BimEntry be) {
        super(be);
        this.allele1 = be.getAllele1();
        this.allele2 = be.getAllele2();
    }

    public boolean isEqualAlleles(BimEntry be) {
        if (be.isMonomorphic() || this.isMonomorphic()) {
            return be.getAllele2().equals(this.allele2);
        }
        if (be.getAllele1().equals(this.allele1) && be.getAllele2().equals(this.allele2)) {
            return true;
        }
        return be.getAllele1().equals(this.allele2) && be.getAllele2().equals(this.allele1);
    }

    public boolean isReversedAlleles(BimEntry be) {
        if (be.isMonomorphic() || this.isMonomorphic()) {
            return this.isReversedMonomorphic(be);
        }
        return be.getAllele1().equals(this.allele2) && be.getAllele2().equals(this.allele1);
    }

    public boolean isReversedMonomorphic(BimEntry be) {
        if (be.isMonomorphic() && this.isMonomorphic()) {
            return false;
        }
        if (be.isMonomorphic()) {
            return be.getAllele2().equals(this.allele1);
        }
        return be.getAllele1().equals(this.allele2);
    }

    public boolean isMonomorphic() {
        return "0".equals(this.allele1);
    }

    public String getAlleleString() {
        return this.allele1 + this.allele2;
    }

    public String[] getAlphaAlleles() {
        int i = this.allele1.compareTo(this.allele2);
        return this.getOrderedAlleles(i);
    }

    public String[] getOrderedAlleles(int i) {
        String[] str = new String[2];
        if (0 < i) {
            str[0] = this.allele2;
            str[1] = this.allele1;
        } else {
            str[0] = this.allele1;
            str[1] = this.allele2;
        }
        return str;
    }

    @Override
    public String toString() {
        return this.toStringBuilder("\t").toString();
    }

    @Override
    public StringBuilder toStringBuilder(String sep) {
        StringBuilder sb = super.toStringBuilder(sep);
        sb.append(sep);
        sb.append(this.allele1);
        sb.append(sep);
        sb.append(this.allele2);
        return sb;
    }

    public String toString(BedConstants.Call c) {
        String[] sa = this.toArray(c);
        return sa[0] + " " + sa[1];
    }

    public String[] toArray(BedConstants.Call c) {
        switch (c) {
            case HOM1: {
                return new String[]{this.allele1, this.allele1};
            }
            case HOM2: {
                return new String[]{this.allele2, this.allele2};
            }
            case HET: {
                return new String[]{this.allele1, this.allele2};
            }
        }
        return new String[]{"0", "0"};
    }

    @Override
    public void set(long lineNumber, long cellPosition, String data) throws Exception {
        if (cellPosition < 5L) {
            super.set(lineNumber, cellPosition, data);
        } else {
            switch ((int)cellPosition) {
                case 5: {
                    this.allele1 = data;
                    break;
                }
                case 6: {
                    this.allele2 = data;
                    break;
                }
            }
        }
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        if (null == this.allele1 || null == this.allele2) {
            throw new NullPointerException("One or more fields has not been set");
        }
    }

    public String getAllele1() {
        return this.allele1;
    }

    public void setAllele1(String allele1) {
        this.allele1 = allele1;
    }

    public String getAllele2() {
        return this.allele2;
    }

    public void setAllele2(String allele2) {
        this.allele2 = allele2;
    }

    @Override
    public void set(Map<String, String> map) {
        super.set(map);
        this.allele1 = map.get("A1");
        this.allele2 = map.get("A2");
    }

    public static class Header
    extends BimEntry {
        MapEntry.Header prev = new MapEntry.Header();

        @Override
        public StringBuilder toStringBuilder(String sep) {
            StringBuilder sb = this.prev.toStringBuilder(sep);
            sb.append(sep);
            sb.append("A1");
            sb.append(sep);
            sb.append("A2");
            return sb;
        }
    }
}

