/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.util.concurrent.ExecutorService;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Configurable;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Node;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.io.BufferConfigurable;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.parser.rig.ParserRig;
import uk.ac.ox.well.t2d.async.ped.BedMetadata;
import uk.ac.ox.well.t2d.async.ped.BedMetadataAggregator;
import uk.ac.ox.well.t2d.async.ped.BimParser;
import uk.ac.ox.well.t2d.async.ped.FamParser;
import uk.ac.ox.well.t2d.async.processors.BucketBase;

public class BimFamLoader
implements Node<Object, BedMetadata>,
Configurable,
BufferConfigurable {
    public static final String STEM_KEY = "BimFamLoader.Stem";
    protected int bucketCount = 3;
    protected int capacity = 20000;
    protected ExecutorService serv;
    MetadataReader proReader = new MetadataReader();
    BimFamMultiplexer mpxr;
    ParserRig famRig;
    ParserRig bimRig;
    BedMetadataAggregator dmpxr;

    public BimFamLoader() {
        this.proReader.setPropertyKey(STEM_KEY);
        this.mpxr = new BimFamMultiplexer();
        this.famRig = new ParserRig();
        this.famRig.setTableParser(new FamParser());
        this.bimRig = new ParserRig();
        this.bimRig.setTableParser(new BimParser());
        this.dmpxr = new BedMetadataAggregator();
    }

    @Override
    public void setBucketCount(int bc) {
        this.bucketCount = bc;
    }

    @Override
    public void setBufferCapacity(int c) {
        this.capacity = c;
    }

    @Override
    public void setExecutorService(ExecutorService es) {
        this.serv = es;
    }

    @Override
    public void commence() {
        this.famRig.setBucketCount(this.bucketCount);
        this.bimRig.setBucketCount(this.bucketCount);
        this.proReader.setExecutorService(this.serv);
        this.famRig.setExecutorService(this.serv);
        this.bimRig.setExecutorService(this.serv);
        this.proReader.setProcessor(this.mpxr);
        this.bimRig.setProcessor((Processor)this.dmpxr);
        this.famRig.setProcessor((Processor)this.dmpxr);
        this.proReader.commence();
        this.mpxr.commence();
        this.bimRig.commence();
        this.famRig.commence();
        this.dmpxr.commence();
    }

    @Override
    public void close() {
        this.bimRig.close();
        this.famRig.close();
        this.dmpxr.close();
    }

    @Override
    public void consume(Contract c, Bucket bin, boolean endOfInput) {
        this.proReader.consume(c, bin, endOfInput);
    }

    @Override
    public void setProcessor(Processor<BedMetadata> processor) {
        this.dmpxr.setProcessor(processor);
    }

    public class BimFamMultiplexer
    implements Processor<String> {
        @Override
        public void commence() {
        }

        @Override
        public void close() {
        }

        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            ContractGroup cg = new ContractGroup(c);
            ContractGroup.SiblingContract fc = cg.newContract(false);
            fc.put("ParserRig.InputPath", bin.getPayload() + ".fam");
            BucketBase fb = new BucketBase();
            BimFamLoader.this.famRig.consume((Contract)fc, (Bucket)fb, endOfInput);
            ContractGroup.SiblingContract bc = cg.newContract(true);
            bc.put("ParserRig.InputPath", bin.getPayload() + ".bim");
            BucketBase bb = new BucketBase();
            BimFamLoader.this.bimRig.consume((Contract)bc, (Bucket)bb, endOfInput);
            bin.recycle();
        }
    }
}

