/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.CallMetricsSummary;

public class CallMetrics {
    protected MathContext mc;
    protected int hom1;
    protected int hom2;
    protected int het;
    protected int nc;
    protected CallMetricsSummary summary;

    public CallMetrics() {
        this.mc = MathContext.DECIMAL64;
    }

    public CallMetrics(MathContext mathCxt) {
        this.mc = mathCxt;
    }

    public CallMetricsSummary getCallMetricsSummary() {
        return this.summary;
    }

    public void setMetricsSummary(CallMetricsSummary cms) {
        this.summary = cms;
        this.summary.addMetrics(this);
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public int getHom1() {
        return this.hom1;
    }

    public int getHom2() {
        return this.hom2;
    }

    public int getHet() {
        return this.het;
    }

    public int getNc() {
        return this.nc;
    }

    public void inc(BedConstants.Call call) {
        switch (call) {
            case HOM1: {
                ++this.hom1;
                break;
            }
            case HOM2: {
                ++this.hom2;
                break;
            }
            case HET: {
                ++this.het;
                break;
            }
            case NC: {
                ++this.nc;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public final int getTotalCalls() {
        return this.hom1 + this.hom2 + this.het + this.nc;
    }

    public final int getNonMissingCalls() {
        return this.hom1 + this.hom2 + this.het;
    }

    public BigDecimal getMissingness() {
        return this.getQuotient(this.getNc(), this.getTotalCalls());
    }

    public BigDecimal getQuotient(int dividend, int divisor) {
        BigDecimal bd1 = new BigDecimal(divisor);
        BigDecimal bd2 = new BigDecimal(dividend);
        if (BigDecimal.ZERO.equals(bd1) || BigDecimal.ZERO.equals(bd2)) {
            return BigDecimal.ZERO;
        }
        return bd2.divide(bd1, this.mc);
    }

    public int getTotalAlleleCount() {
        return (this.hom1 + this.hom2 + this.het) * 2;
    }

    public void add(CallMetrics cm) {
        this.hom1 += cm.getHom1();
        this.het += cm.getHet();
        this.hom2 += cm.getHom2();
        this.nc += cm.getNc();
    }

    public CallMetrics reverse() {
        CallMetrics cm = new CallMetrics();
        cm.hom1 = this.hom2;
        cm.het = this.het;
        cm.hom2 = this.hom1;
        cm.nc = this.nc;
        return cm;
    }

    public String toString() {
        return this.toStringBuilder("\t").toString();
    }

    public StringBuilder toStringBuilder(String sep) {
        StringBuilder sb = new StringBuilder();
        this.write(sep, sb);
        return sb;
    }

    public void write(String sep, StringBuilder sb) {
        sb.append(this.hom1);
        sb.append(sep);
        sb.append(this.het);
        sb.append(sep);
        sb.append(this.hom2);
        sb.append(sep);
        sb.append(this.nc);
    }

    public void set(Map<String, String> map) {
        if (map.containsKey("HOM1")) {
            this.hom1 = Integer.parseInt(map.get("HOM1"));
        }
        if (map.containsKey("HET")) {
            this.het = Integer.parseInt(map.get("HET"));
        }
        if (map.containsKey("HOM2")) {
            this.hom2 = Integer.parseInt(map.get("HOM2"));
        }
        if (map.containsKey("NC")) {
            this.nc = Integer.parseInt(map.get("NC"));
        }
    }

    public static class Header
    extends CallMetrics {
        @Override
        public StringBuilder toStringBuilder(String sep) {
            StringBuilder sb = new StringBuilder();
            sb.append("HOM1");
            sb.append(sep);
            sb.append("HET");
            sb.append(sep);
            sb.append("HOM2");
            sb.append(sep);
            sb.append("NC");
            return sb;
        }
    }
}

