/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import uk.ac.ox.well.t2d.async.ped.PedEntry;

public class FamEntry
extends PedEntry {
    protected String familyId;
    protected String individualId;
    protected String paternalId;
    protected String maternalId;
    protected String sex;
    protected String phenotype;
    protected String uuid;

    public FamEntry() {
    }

    public FamEntry(FamEntry fe) {
        super(fe);
        this.familyId = fe.getFamilyId();
        this.individualId = fe.getIndividualId();
        this.paternalId = fe.getPaternalId();
        this.maternalId = fe.getMaternalId();
        this.sex = fe.getSex();
        this.phenotype = fe.getPhenotype();
        this.uuid = fe.getId();
    }

    public void basicSetup(String sampleId) {
        this.familyId = sampleId;
        this.individualId = sampleId;
        this.paternalId = "0";
        this.maternalId = "0";
        this.sex = "-9";
        this.phenotype = "-9";
    }

    @Override
    public void set(long lineNumber, long cellPosition, String data) throws Exception {
        super.set(lineNumber, cellPosition, data);
        switch ((int)cellPosition) {
            case 1: {
                this.familyId = data;
                break;
            }
            case 2: {
                this.individualId = data;
                break;
            }
            case 3: {
                this.paternalId = data;
                break;
            }
            case 4: {
                this.maternalId = data;
                break;
            }
            case 5: {
                this.sex = data;
                break;
            }
            case 6: {
                this.phenotype = data;
                break;
            }
        }
    }

    @Override
    public void validate() throws Exception {
        if (null == this.familyId || null == this.individualId || null == this.paternalId || null == this.maternalId || null == this.sex || null == this.phenotype) {
            throw new NullPointerException("One or more fields has not been set");
        }
        this.uuid = this.familyId + "\t" + this.individualId;
    }

    @Override
    public String getId() {
        return this.uuid;
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public void setFamilyId(String familyId) {
        this.familyId = familyId;
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public void setIndividualId(String individualId) {
        this.individualId = individualId;
    }

    public String getPaternalId() {
        return this.paternalId;
    }

    public void setPaternalId(String paternalId) {
        this.paternalId = paternalId;
    }

    public String getMaternalId() {
        return this.maternalId;
    }

    public void setMaternalId(String maternalId) {
        this.maternalId = maternalId;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getPhenotype() {
        return this.phenotype;
    }

    public void setPhenotype(String phenotype) {
        this.phenotype = phenotype;
    }

    public String toString() {
        return this.toStringBuilder("\t").toString();
    }

    public StringBuilder toStringBuilder(String sep) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.familyId);
        sb.append(sep);
        sb.append(this.individualId);
        sb.append(sep);
        sb.append(this.paternalId);
        sb.append(sep);
        sb.append(this.maternalId);
        sb.append(sep);
        sb.append(this.sex);
        sb.append(sep);
        sb.append(this.phenotype);
        return sb;
    }

    public static class Header
    extends FamEntry {
        @Override
        public StringBuilder toStringBuilder(String sep) {
            StringBuilder sb = new StringBuilder();
            sb.append("FID");
            sb.append(sep);
            sb.append("IID");
            sb.append(sep);
            sb.append("PID");
            sb.append(sep);
            sb.append("MID");
            sb.append(sep);
            sb.append("SEX");
            sb.append(sep);
            sb.append("PTYP");
            return sb;
        }
    }
}

