/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.math.BigDecimal;
import java.math.MathContext;
import uk.ac.ox.well.t2d.async.ped.CallMetrics;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.ped.IndividualMetricsSummary;

public class IndividualMetrics
extends CallMetrics {
    private FamEntry famEntry = new FamEntry();

    public IndividualMetrics() {
    }

    public IndividualMetrics(MathContext mathCxt) {
        super(mathCxt);
    }

    public IndividualMetricsSummary getIndividualMetricsSummary() {
        return (IndividualMetricsSummary)this.summary;
    }

    public FamEntry getFamEntry() {
        return this.famEntry;
    }

    public void setFamEntry(FamEntry famEntry) {
        this.famEntry = famEntry;
    }

    public BigDecimal getHeterozygosity() {
        int nmiss_count = this.getNonMissingCalls();
        int het_count = this.getHet();
        BigDecimal bd1 = new BigDecimal(nmiss_count);
        BigDecimal bd2 = new BigDecimal(het_count);
        if (BigDecimal.ZERO.equals(bd1)) {
            return BigDecimal.ZERO;
        }
        return bd2.divide(bd1, this.mc);
    }

    public double getHeterozygStanDevToMean() {
        double mean;
        if (null == this.summary) {
            return 0.0;
        }
        double htzg = this.getHeterozygosity().doubleValue();
        double dist = htzg - (mean = this.getIndividualMetricsSummary().getHeterozygosity().getMean());
        if (dist < 0.0) {
            dist *= -1.0;
        }
        double sd = this.getIndividualMetricsSummary().getHeterozygosity().getStandardDeviation();
        double rv = dist / sd;
        return rv;
    }

    @Override
    public String toString() {
        return this.toStringBuilder("\t").toString();
    }

    @Override
    public StringBuilder toStringBuilder(String sep) {
        StringBuilder sb = this.famEntry.toStringBuilder(sep);
        sb.append(sep);
        super.write(sep, sb);
        sb.append(sep);
        sb.append(this.getMissingness().toPlainString());
        sb.append(sep);
        sb.append(this.getHeterozygosity().toPlainString());
        sb.append(sep);
        sb.append(this.getHeterozygStanDevToMean());
        return sb;
    }

    public static class Header
    extends IndividualMetrics {
        FamEntry.Header prev1 = new FamEntry.Header();
        CallMetrics.Header prev2 = new CallMetrics.Header();

        @Override
        public StringBuilder toStringBuilder(String sep) {
            StringBuilder sb1 = this.prev1.toStringBuilder(sep);
            sb1.append(sep);
            StringBuilder sb2 = this.prev2.toStringBuilder(sep);
            sb1.append((CharSequence)sb2);
            sb1.append(sep);
            sb1.append("MISS");
            sb1.append(sep);
            sb1.append("HETZGY_MEAN");
            sb1.append(sep);
            sb1.append("HETZGY_SD_MEAN");
            return sb1;
        }
    }
}

