/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.nio.ByteBuffer;
import java.util.List;
import uk.ac.ox.well.t2d.async.contracts.ListFactory;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.CallMetricsContext;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.ped.IndividualMetrics;
import uk.ac.ox.well.t2d.async.ped.IndividualMetricsSummary;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class IndividualMetricsParser
extends AbstractConveyor<Cxt, ByteBuffer, List<IndividualMetrics>> {
    public IndividualMetricsParser() {
        this.setPayloadManager(new ListFactory());
    }

    @Override
    protected Cxt newContext() {
        return new Cxt();
    }

    public static class Cxt
    extends CallMetricsContext<IndividualMetrics> {
        @Override
        public void newMetrics(List<IndividualMetrics> iml) {
            for (FamEntry fe : this.meta.getFamList()) {
                IndividualMetrics im = new IndividualMetrics();
                im.setFamEntry(fe);
                iml.add(im);
            }
        }

        @Override
        public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
            IndividualMetrics metrics = (IndividualMetrics)this.metricsList.get(sampleIndex);
            metrics.inc(call);
        }

        @Override
        public IndividualMetrics newMetricsHeader() {
            return new IndividualMetrics.Header();
        }

        @Override
        public void summarize(List<IndividualMetrics> iml) {
            IndividualMetricsSummary ims = new IndividualMetricsSummary();
            for (IndividualMetrics im : iml) {
                im.setMetricsSummary(ims);
            }
        }
    }
}

