/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.util.Map;
import uk.ac.ox.well.t2d.async.ped.PedEntry;

public class MapEntry
extends PedEntry {
    protected String chromosome;
    protected String snpId;
    protected String distance;
    protected String position;

    public MapEntry() {
    }

    public MapEntry(MapEntry me) {
        super(me);
        this.chromosome = me.getChromosome();
        this.snpId = me.getSnpId();
        this.distance = me.getDistance();
        this.position = me.getPosition();
    }

    public String toString() {
        return this.toStringBuilder("\t").toString();
    }

    public StringBuilder toStringBuilder(String sep) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.chromosome);
        sb.append("\t");
        sb.append(this.snpId);
        sb.append("\t");
        sb.append(this.distance);
        sb.append("\t");
        sb.append(this.position);
        return sb;
    }

    @Override
    public void set(long lineNumber, long cellPosition, String data) throws Exception {
        super.set(lineNumber, cellPosition, data);
        switch ((int)cellPosition) {
            case 1: {
                this.chromosome = data;
                break;
            }
            case 2: {
                this.snpId = data;
                break;
            }
            case 3: {
                this.distance = data;
                break;
            }
            case 4: {
                this.position = data;
                break;
            }
        }
    }

    @Override
    public void validate() throws Exception {
        if (null == this.chromosome || null == this.snpId || null == this.distance || null == this.position) {
            throw new NullPointerException("One or more fields has not been set");
        }
    }

    @Override
    public String getId() {
        return this.getSnpId();
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public String getSnpId() {
        return this.snpId;
    }

    public void setSnpId(String snpId) {
        this.snpId = snpId;
    }

    public String getDistance() {
        return this.distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void set(Map<String, String> map) {
        this.snpId = map.get("SNPID");
        this.chromosome = map.get("CHR");
        this.position = map.get("POS");
        this.distance = map.get("DIST");
    }

    public static class Header
    extends MapEntry {
        @Override
        public StringBuilder toStringBuilder(String sep) {
            StringBuilder sb = new StringBuilder();
            sb.append("CHR");
            sb.append(sep);
            sb.append("SNPID");
            sb.append(sep);
            sb.append("DIST");
            sb.append(sep);
            sb.append("POS");
            return sb;
        }
    }
}

