/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Formatter;
import java.util.Map;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.CallMetrics;

public class SnpMetrics
extends CallMetrics {
    private BimEntry bimEntry = new BimEntry();

    public SnpMetrics() {
    }

    public SnpMetrics(MathContext mathCxt) {
        super(mathCxt);
    }

    public BimEntry getBimEntry() {
        return this.bimEntry;
    }

    public void setBimEntry(BimEntry bimEntry) {
        this.bimEntry = bimEntry;
    }

    public BigDecimal getMinorAlleleFrequency() {
        int i = this.getMinorHomozygote();
        if (0 < i) {
            return this.getMinorAlleleFrequency(this.hom2, this.het);
        }
        return this.getMinorAlleleFrequency(this.hom1, this.het);
    }

    public int getMinorAlleleCount() {
        int i = this.getMinorHomozygote();
        if (0 < i) {
            return this.getMinorAlleleCount(this.hom2, this.het);
        }
        return this.getMinorAlleleCount(this.hom1, this.het);
    }

    public int getMinorAlleleCount(int minorHomCount, int hetCount) {
        return minorHomCount * 2 + hetCount;
    }

    public BigDecimal getMinorAlleleFrequency(int minorHomCount, int hetCount) {
        int allele_count = this.getTotalAlleleCount();
        int minor_count = this.getMinorAlleleCount(minorHomCount, hetCount);
        BigDecimal bd1 = new BigDecimal(allele_count);
        BigDecimal bd2 = new BigDecimal(minor_count);
        if (BigDecimal.ZERO.equals(bd1) || BigDecimal.ZERO.equals(bd2)) {
            return BigDecimal.ZERO;
        }
        return bd2.divide(bd1, this.mc);
    }

    public int getMinorHomozygote() {
        if (this.hom1 == this.hom2) {
            return 0;
        }
        if (this.hom1 < this.hom2) {
            return -1;
        }
        return 1;
    }

    public int getMajorHomozygote() {
        return -1 * this.getMinorHomozygote();
    }

    public String[] getOrderedAlleles() {
        int i = this.getMinorHomozygote();
        if (0 == i) {
            return this.bimEntry.getAlphaAlleles();
        }
        return this.bimEntry.getOrderedAlleles(i);
    }

    public void merge(SnpMetrics sm) throws IncompatibleAlleleException {
        if (this.bimEntry.isEqualAlleles(sm.getBimEntry())) {
            if (this.bimEntry.isReversedAlleles(sm.getBimEntry())) {
                CallMetrics reversed = sm.reverse();
                super.add(reversed);
            } else {
                super.add(sm);
            }
        } else {
            Formatter f = new Formatter();
            f.format("Unable to merge SnpMetrics for %s. Incompatible alleles, expecting %s found %s", sm.getBimEntry().getSnpId(), this.bimEntry.getAlleleString(), sm.getBimEntry().getAlleleString());
            throw new IncompatibleAlleleException(f.toString());
        }
    }

    @Override
    public void set(Map<String, String> map) {
        this.bimEntry.set(map);
        super.set(map);
    }

    @Override
    public String toString() {
        return this.toStringBuilder("\t").toString();
    }

    @Override
    public StringBuilder toStringBuilder(String sep) {
        StringBuilder sb = this.bimEntry.toStringBuilder(sep);
        sb.append(sep);
        super.write(sep, sb);
        sb.append(sep);
        sb.append(this.getMissingness().toPlainString());
        sb.append(sep);
        sb.append(this.getTotalAlleleCount());
        sb.append(sep);
        sb.append(this.getMinorAlleleCount());
        sb.append(sep);
        sb.append(this.getMinorAlleleFrequency().toPlainString());
        sb.append(sep);
        String[] orderedAlleles = this.getOrderedAlleles();
        sb.append(orderedAlleles[0]);
        sb.append(sep);
        sb.append(orderedAlleles[1]);
        return sb;
    }

    public static class IncompatibleAlleleException
    extends Exception {
        public IncompatibleAlleleException(String msg) {
            super(msg);
        }
    }

    public static class Header
    extends SnpMetrics {
        BimEntry.Header prev1 = new BimEntry.Header();
        CallMetrics.Header prev2 = new CallMetrics.Header();

        @Override
        public StringBuilder toStringBuilder(String sep) {
            StringBuilder sb1 = this.prev1.toStringBuilder(sep);
            sb1.append(sep);
            StringBuilder sb2 = this.prev2.toStringBuilder(sep);
            sb1.append((CharSequence)sb2);
            sb1.append(sep);
            sb1.append("MISS");
            sb1.append(sep);
            sb1.append("TOT_AL_CT");
            sb1.append(sep);
            sb1.append("MIN_AL_CT");
            sb1.append(sep);
            sb1.append("MIN_AL_FRQ");
            sb1.append(sep);
            sb1.append("MIN_AL");
            sb1.append(sep);
            sb1.append("MAJ_AL");
            return sb1;
        }
    }
}

