/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.ProcessingContext;
import uk.ac.ox.well.t2d.async.ProcessingResult;
import uk.ac.ox.well.t2d.async.ped.SnpMetrics;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class SnpMetricsMerger
extends AbstractConveyor<Context, List<SnpMetrics>, List<SnpMetrics>> {
    protected boolean outputHeader = true;

    @Override
    protected Context newContext() {
        return new Context();
    }

    public class Context
    extends ProcessingContext<List<SnpMetrics>, List<SnpMetrics>> {
        Map<String, SnpMetrics> map = new LinkedHashMap<String, SnpMetrics>();

        @Override
        public void clear() {
            super.clear();
            this.map.clear();
        }

        @Override
        public ProcessingResult process(List<SnpMetrics> pi, Bucket<List<SnpMetrics>> bo, boolean endOfContract) throws Exception {
            this.handleMetrics(pi);
            if (endOfContract) {
                ArrayList<SnpMetrics> out = new ArrayList<SnpMetrics>();
                if (SnpMetricsMerger.this.outputHeader) {
                    out.add(new SnpMetrics.Header());
                }
                out.addAll(this.map.values());
                bo.setPayload(out);
                return ProcessingResult.BOTH_COMPLETE;
            }
            return ProcessingResult.INPUT_COMPLETE;
        }

        public void handleMetrics(List<SnpMetrics> in) throws Exception {
            for (SnpMetrics sm : in) {
                String snpId = sm.getBimEntry().getSnpId();
                if (this.map.containsKey(snpId)) {
                    SnpMetrics existing = this.map.get(snpId);
                    try {
                        existing.merge(sm);
                    }
                    catch (SnpMetrics.IncompatibleAlleleException ex) {
                        SnpMetricsMerger.this.logger.warn("Unable to merge SNP metrics", ex);
                    }
                    continue;
                }
                this.map.put(sm.getBimEntry().getSnpId(), sm);
            }
        }
    }
}

