/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped;

import java.nio.ByteBuffer;
import java.util.List;
import uk.ac.ox.well.t2d.async.contracts.ListFactory;
import uk.ac.ox.well.t2d.async.ped.BedConstants;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.CallMetricsContext;
import uk.ac.ox.well.t2d.async.ped.CallMetricsSummary;
import uk.ac.ox.well.t2d.async.ped.SnpMetrics;
import uk.ac.ox.well.t2d.async.processors.AbstractConveyor;

public class SnpMetricsParser
extends AbstractConveyor<Cxt, ByteBuffer, List<SnpMetrics>> {
    public SnpMetricsParser() {
        this.setPayloadManager(new ListFactory());
    }

    @Override
    protected Cxt newContext() {
        return new Cxt();
    }

    public static class Cxt
    extends CallMetricsContext<SnpMetrics> {
        @Override
        public SnpMetrics newMetricsHeader() {
            return new SnpMetrics.Header();
        }

        @Override
        public void newMetrics(List<SnpMetrics> sml) {
            for (BimEntry be : this.meta.getBimList()) {
                SnpMetrics sm = new SnpMetrics();
                sm.setBimEntry(be);
                sml.add(sm);
            }
        }

        @Override
        public void handleCall(int snpIndex, int sampleIndex, BedConstants.Call call) {
            SnpMetrics metrics = (SnpMetrics)this.metricsList.get(snpIndex);
            metrics.inc(call);
        }

        @Override
        public void summarize(List<SnpMetrics> sml) {
            CallMetricsSummary cms = new CallMetricsSummary();
            for (SnpMetrics cm : sml) {
                cm.setMetricsSummary(cms);
            }
        }
    }
}

