/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.ped.diff;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import uk.ac.ox.well.t2d.async.ped.BedMetadata;
import uk.ac.ox.well.t2d.async.ped.BimEntry;
import uk.ac.ox.well.t2d.async.ped.FamEntry;
import uk.ac.ox.well.t2d.async.ped.diff.BimIndex;
import uk.ac.ox.well.t2d.async.ped.diff.FamIndex;
import uk.ac.ox.well.t2d.async.ped.diff.PedEntryIndex;

public class BedOverlap
implements Runnable {
    private BimIndex.IdStrategy snpIdStrategy = BimIndex.IdStrategy.CHRPOS;
    private PedEntryIndex.DuplicateStrategy snpDupStrategy = PedEntryIndex.DuplicateStrategy.NEITHER;
    private FamIndex.IdStrategy sampleIdStrategy = FamIndex.IdStrategy.BOTH;
    private PedEntryIndex.DuplicateStrategy sampleDupStrategy = PedEntryIndex.DuplicateStrategy.NEITHER;
    protected BedMetadata bed1;
    protected BedMetadata bed2;
    protected BimIndex bi1;
    protected BimIndex bi2;
    protected FamIndex fi1;
    protected FamIndex fi2;
    protected Set<String> bintersection;
    protected Set<String> fintersection;

    public BedMetadata getBedMetadata1() {
        return this.bed1;
    }

    public BedMetadata getBedMetadata2() {
        return this.bed2;
    }

    public void setBedMetadata1(BedMetadata b1) {
        this.bed1 = b1;
    }

    public void setBedMetadata2(BedMetadata b2) {
        this.bed2 = b2;
    }

    public BimIndex.IdStrategy getSnpIdStrategy() {
        return this.snpIdStrategy;
    }

    public void setSnpIdStrategy(BimIndex.IdStrategy snpIdStrategy) {
        this.snpIdStrategy = snpIdStrategy;
    }

    public PedEntryIndex.DuplicateStrategy getSnpDupStrategy() {
        return this.snpDupStrategy;
    }

    public void setSnpDupStrategy(PedEntryIndex.DuplicateStrategy snpDupStrategy) {
        this.snpDupStrategy = snpDupStrategy;
    }

    public FamIndex.IdStrategy getSampleIdStrategy() {
        return this.sampleIdStrategy;
    }

    public void setSampleIdStrategy(FamIndex.IdStrategy sampleIdStrategy) {
        this.sampleIdStrategy = sampleIdStrategy;
    }

    public PedEntryIndex.DuplicateStrategy getSampleDupStrategy() {
        return this.sampleDupStrategy;
    }

    public void setSampleDupStrategy(PedEntryIndex.DuplicateStrategy sampleDupStrategy) {
        this.sampleDupStrategy = sampleDupStrategy;
    }

    @Override
    public void run() {
        this.buildIndexes();
        this.calcIntersection();
    }

    protected void buildIndexes() {
        this.bi1 = new BimIndex(this.snpIdStrategy, this.snpDupStrategy);
        this.bi1.addAll(this.bed1.getBimList());
        this.bi2 = new BimIndex(this.snpIdStrategy, this.snpDupStrategy);
        this.bi2.addAll(this.bed2.getBimList());
        this.fi1 = new FamIndex(this.sampleIdStrategy, this.sampleDupStrategy);
        this.fi1.addAll(this.bed1.getFamList());
        this.fi2 = new FamIndex(this.sampleIdStrategy, this.sampleDupStrategy);
        this.fi2.addAll(this.bed2.getFamList());
    }

    protected void calcIntersection() {
        Set<String> bids1 = this.bi1.getIncludedIds();
        Set<String> bids2 = this.bi1.getIncludedIds();
        this.bintersection = new LinkedHashSet<String>();
        this.bintersection.addAll(bids1);
        this.bintersection.retainAll(bids2);
        Set<String> fids1 = this.fi1.getIncludedIds();
        Set<String> fids2 = this.fi1.getIncludedIds();
        this.fintersection = new LinkedHashSet<String>();
        this.fintersection.addAll(fids1);
        this.fintersection.retainAll(fids2);
    }

    public Set<String> getBimIntersection() {
        return this.bintersection;
    }

    public Set<String> getFamIntersection() {
        return this.fintersection;
    }

    public List<BimEntry> getBimIndex1() {
        return this.bi1.newIndex(this.bintersection);
    }

    public List<BimEntry> getBimIndex2() {
        return this.bi2.newIndex(this.bintersection);
    }

    public List<FamEntry> getFamIndex1() {
        return this.fi1.newIndex(this.fintersection);
    }

    public List<FamEntry> getFamIndex2() {
        return this.fi2.newIndex(this.fintersection);
    }
}

